/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.initialization.qual.UnknownInitialization;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.DotSeparatedIdentifiers;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.reflection.Signatures;
import randoop.org.plumelib.util.CollectionsPlume;
import randoop.org.plumelib.util.StringsPlume;

public class RawSignature {
    private final @Nullable @DotSeparatedIdentifiers @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String packageName;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String classname;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String name;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] parameterTypes;

    public RawSignature(@Nullable @DotSeparatedIdentifiers @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String packageName, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String classname, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String name, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] parameterTypes) {
        this.packageName = packageName;
        this.classname = classname;
        this.name = name;
        this.parameterTypes = parameterTypes;
        this.checkRep();
    }

    private void checkRep(@UnknownInitialization RawSignature this) {
        if (Objects.equals(this.packageName, "")) {
            throw new Error("Represent the default package by `null`, not the empty string: " + this.toStringDebug());
        }
        if (this.packageName != null && !Signatures.isDotSeparatedIdentifiers(this.packageName)) {
            throw new Error("Bad package name: " + this.toStringDebug());
        }
        if (this.classname == null || !Signatures.isIdentifier(this.classname)) {
            throw new Error("Bad class name: " + this.toStringDebug());
        }
        if (this.name == null || !Signatures.isIdentifier(this.name)) {
            throw new Error("Bad name: " + this.toStringDebug());
        }
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RawSignature of(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method executable) {
        Package classPackage = executable.getDeclaringClass().getPackage();
        String packageName = RawSignature.getPackageName(classPackage);
        String fullclassname = executable.getDeclaringClass().getName();
        String classname = packageName == null ? fullclassname : fullclassname.substring(packageName.length() + 1);
        return new RawSignature(packageName, classname, executable.getName(), executable.getParameterTypes());
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RawSignature of(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Constructor<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> executable) {
        Package classPackage = executable.getDeclaringClass().getPackage();
        String packageName = RawSignature.getPackageName(classPackage);
        String fullclassname = executable.getDeclaringClass().getName();
        String classname = packageName == null ? fullclassname : fullclassname.substring(packageName.length() + 1);
        String fullname = executable.getName();
        String name = packageName == null ? fullname : fullname.substring(packageName.length() + 1);
        return new RawSignature(packageName, classname, name, executable.getParameterTypes());
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RawSignature)) {
            return false;
        }
        RawSignature that = (RawSignature)object;
        return Objects.equals(this.packageName, that.packageName) && this.classname.equals(that.classname) && this.name.equals(that.name) && Arrays.equals(this.parameterTypes, that.parameterTypes);
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.classname, this.name, Arrays.hashCode(this.parameterTypes));
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        List<@NonNull String> typeNames = CollectionsPlume.mapList(Class::getCanonicalName, this.parameterTypes);
        return (this.packageName == null ? "" : this.packageName + ".") + (this.classname.equals(this.name) ? this.name : this.classname + "." + this.name) + "(" + StringsPlume.join((CharSequence)",", typeNames) + ")";
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toStringDebug() {
        StringJoiner result = new StringJoiner(System.lineSeparator());
        result.add("RawSignature{");
        result.add("  packageName = " + this.packageName);
        result.add("  className = " + this.classname);
        result.add("  name = " + this.name);
        result.add("  parameterTypes = " + Arrays.toString(this.parameterTypes));
        result.add("}");
        return result.toString();
    }

    public @DotSeparatedIdentifiers @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String getPackageName() {
        return this.packageName;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getClassname() {
        return this.classname;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getName() {
        return this.name;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getDeclarationArguments(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> parameterNames) {
        if (parameterNames.size() != this.parameterTypes.length) {
            String message = String.format("Number of parameter names %d (%s) must match the number of parameter types %d (%s) for %s", parameterNames.size(), parameterNames, this.parameterTypes.length, Arrays.toString(this.parameterTypes), this);
            throw new IllegalArgumentException(message);
        }
        StringJoiner paramDeclarations = new StringJoiner(", ", "(", ")");
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            paramDeclarations.add(this.parameterTypes[i].getCanonicalName() + " " + parameterNames.get(i));
        }
        return paramDeclarations.toString();
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] getParameterTypes() {
        return this.parameterTypes;
    }

    public static @Nullable @DotSeparatedIdentifiers @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String getPackageName(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Package aPackage) {
        if (aPackage == null) {
            return null;
        }
        String result = aPackage.getName();
        if (result.equals("")) {
            return null;
        }
        return result;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String classToIdentifier(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> c) {
        return RawSignature.classNameToIdentifier(c.getSimpleName());
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String classNameToIdentifier(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String name) {
        String result = name;
        result = result.replace("[]", "ARRAY");
        result = result.replace("<", "");
        result = result.replace(">", "");
        result = result.replace(",", "");
        return result;
    }
}

