/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import randoop.Globals;
import randoop.condition.SpecificationCollection;
import randoop.contract.CompareToAntiSymmetric;
import randoop.contract.CompareToEquals;
import randoop.contract.CompareToReflexive;
import randoop.contract.CompareToSubs;
import randoop.contract.CompareToTransitive;
import randoop.contract.EqualsHashcode;
import randoop.contract.EqualsReflexive;
import randoop.contract.EqualsReturnsNormally;
import randoop.contract.EqualsSymmetric;
import randoop.contract.EqualsToNullRetFalse;
import randoop.contract.EqualsTransitive;
import randoop.contract.SizeToArrayLength;
import randoop.generation.ComponentManager;
import randoop.main.ClassNameErrorHandler;
import randoop.main.GenInputsAbstract;
import randoop.main.RandoopBug;
import randoop.main.RandoopClassNameError;
import randoop.main.RandoopUsageError;
import randoop.operation.OperationParseException;
import randoop.operation.TypedClassOperation;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.ClassGetName;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.plumelib.util.EntryReader;
import randoop.org.plumelib.util.StringsPlume;
import randoop.org.plumelib.util.UtilPlume;
import randoop.reflection.AccessibilityPredicate;
import randoop.reflection.CheckRepExtractor;
import randoop.reflection.ClassLiteralExtractor;
import randoop.reflection.DeclarationExtractor;
import randoop.reflection.EverythingAllowedPredicate;
import randoop.reflection.FailedPredicateException;
import randoop.reflection.LiteralFileReader;
import randoop.reflection.OmitMethodsPredicate;
import randoop.reflection.OperationExtractor;
import randoop.reflection.ReflectionManager;
import randoop.reflection.ReflectionPredicate;
import randoop.reflection.SignatureParseException;
import randoop.reflection.SignatureParser;
import randoop.reflection.TestValueExtractor;
import randoop.reflection.TypeExtractor;
import randoop.reflection.TypeNames;
import randoop.sequence.Sequence;
import randoop.test.ContractSet;
import randoop.types.ClassOrInterfaceType;
import randoop.types.Type;
import randoop.util.Log;
import randoop.util.MultiMap;
import randoop.util.Util;

public class OperationModel {
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType> classTypes = new TreeSet<ClassOrInterfaceType>();
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type> inputTypes = new TreeSet<Type>();
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown LinkedHashSet<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?>> coveredClassesGoal;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MultiMap<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> classLiteralMap = new MultiMap();
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> annotatedTestValues = new LinkedHashSet<Sequence>();
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ContractSet contracts = new ContractSet();
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation> operations;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Pattern> omitMethods;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OmitMethodsPredicate omitMethodsPredicate;

    private OperationModel() {
        this.contracts.add(EqualsReflexive.getInstance());
        this.contracts.add(EqualsSymmetric.getInstance());
        this.contracts.add(EqualsHashcode.getInstance());
        this.contracts.add(EqualsToNullRetFalse.getInstance());
        this.contracts.add(EqualsReturnsNormally.getInstance());
        this.contracts.add(EqualsTransitive.getInstance());
        this.contracts.add(CompareToReflexive.getInstance());
        this.contracts.add(CompareToAntiSymmetric.getInstance());
        this.contracts.add(CompareToEquals.getInstance());
        this.contracts.add(CompareToSubs.getInstance());
        this.contracts.add(CompareToTransitive.getInstance());
        this.contracts.add(SizeToArrayLength.getInstance());
        this.coveredClassesGoal = new LinkedHashSet();
        this.operations = new TreeSet<TypedOperation>();
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationModel createModel(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate accessibility, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Pattern> omitMethods, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String> classnames, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String> coveredClassesGoalNames, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassNameErrorHandler errorHandler, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> literalsFileList, @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SpecificationCollection operationSpecifications) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SignatureParseException, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown NoSuchMethodException {
        OperationModel model = new OperationModel();
        model.omitMethods = omitMethods;
        model.addClassTypes(accessibility, reflectionPredicate, classnames, coveredClassesGoalNames, errorHandler, literalsFileList);
        model.omitMethodsPredicate = new OmitMethodsPredicate(omitMethods);
        model.addOperationsFromClasses(accessibility, reflectionPredicate, operationSpecifications);
        model.operations.addAll(model.getOperationsFromFile(GenInputsAbstract.methodlist, accessibility, reflectionPredicate));
        model.addObjectConstructor();
        return model;
    }

    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationModel createModel(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate accessibility, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String> classnames, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String> coveredClassnames, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassNameErrorHandler errorHandler, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> literalsFileList) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown NoSuchMethodException, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SignatureParseException {
        return OperationModel.createModel(accessibility, reflectionPredicate, new ArrayList<Pattern>(0), classnames, coveredClassnames, errorHandler, literalsFileList, null);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationModel createModel(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate accessibility, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Pattern> omitMethods, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String> classnames, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String> coveredClassnames, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassNameErrorHandler errorHandler, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> literalsFileList) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown NoSuchMethodException, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SignatureParseException {
        return OperationModel.createModel(accessibility, reflectionPredicate, omitMethods, classnames, coveredClassnames, errorHandler, literalsFileList, null);
    }

    public void addClassLiterals(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ComponentManager compMgr, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> literalsFileList, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GenInputsAbstract.ClassLiteralsMode literalsLevel) {
        for (String literalsFile : literalsFileList) {
            MultiMap<ClassOrInterfaceType, Sequence> literalMap = literalsFile.equals("CLASSES") ? this.classLiteralMap : LiteralFileReader.parse(literalsFile);
            for (ClassOrInterfaceType type : literalMap.keySet()) {
                Package pkg = literalsLevel == GenInputsAbstract.ClassLiteralsMode.PACKAGE ? type.getPackage() : null;
                block7: for (Sequence seq : literalMap.getValues(type)) {
                    switch (literalsLevel) {
                        case CLASS: {
                            compMgr.addClassLevelLiteral(type, seq);
                            continue block7;
                        }
                        case PACKAGE: {
                            assert (pkg != null);
                            compMgr.addPackageLevelLiteral(pkg, seq);
                            continue block7;
                        }
                        case ALL: {
                            compMgr.addGeneratedSequence(seq);
                            continue block7;
                        }
                    }
                    throw new Error("Unexpected error in GenTests.  Please report at https://github.com/randoop/randoop/issues , providing the information requested at https://randoop.github.io/randoop/manual/index.html#bug-reporting .");
                }
            }
        }
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MultiMap<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation> readOperations(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path file) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationParseException {
        return OperationModel.readOperations(file, false);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MultiMap<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation> readOperations(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path file, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean ignoreParseError) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationParseException {
        if (file != null) {
            MultiMap<Type, TypedClassOperation> multiMap;
            EntryReader er = new EntryReader(file, "(//|#).*$", null);
            Throwable throwable = null;
            try {
                multiMap = OperationModel.readOperations(er, ignoreParseError);
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        OperationModel.$closeResource(throwable, er);
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    String message = String.format("Error while reading file %s: %s%n", Util.pathAndAbsolute(file), e.getMessage());
                    throw new RandoopUsageError(message, e);
                }
            }
            OperationModel.$closeResource(throwable, er);
            return multiMap;
        }
        return new MultiMap<Type, TypedClassOperation>(0);
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MultiMap<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation> readOperations(@UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown EntryReader er, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean ignoreParseError) {
        MultiMap<Type, TypedClassOperation> operationsMap = new MultiMap<Type, TypedClassOperation>();
        for (String line : er) {
            TypedClassOperation operation;
            String sig = line.trim();
            try {
                operation = OperationModel.signatureToOperation(sig, AccessibilityPredicate.IS_ANY, new EverythingAllowedPredicate());
            }
            catch (SignatureParseException e) {
                if (ignoreParseError) continue;
                throw new RandoopUsageError(String.format("%s:%d: %s", er.getFileName(), er.getLineNumber(), e));
            }
            catch (FailedPredicateException e) {
                throw new RandoopBug("This can't happen", e);
            }
            if (operation.getInputTypes().size() <= 0) continue;
            operationsMap.add(operation.getInputTypes().get(0), operation);
        }
        return operationsMap;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MultiMap<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation> readOperations(@UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InputStream is, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String filename) {
        return OperationModel.readOperations(is, filename, false);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MultiMap<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation> readOperations(@UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InputStream is, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String filename, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean ignoreParseError) {
        MultiMap<Type, TypedClassOperation> multiMap;
        if (is == null) {
            throw new RandoopBug("input stream is null for file " + filename);
        }
        EntryReader er = new EntryReader(is, filename, "^#.*", null);
        Throwable throwable = null;
        try {
            multiMap = OperationModel.readOperations(er, ignoreParseError);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    OperationModel.$closeResource(throwable, er);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                String message = String.format("Error while reading file %s: %s%n", Util.filenameAndAbsolute(filename), e.getMessage());
                throw new RandoopUsageError(message, e);
            }
        }
        OperationModel.$closeResource(throwable, er);
        return multiMap;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType> getClassTypes() {
        return this.classTypes;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?>> getCoveredClassesGoal() {
        return this.coveredClassesGoal;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type> getInputTypes() {
        return this.inputTypes;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation> getOperations() {
        return new ArrayList<TypedOperation>(this.operations);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ContractSet getContracts() {
        return this.contracts;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OmitMethodsPredicate getOmitMethodsPredicate() {
        return this.omitMethodsPredicate;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> getAnnotatedTestValues() {
        return this.annotatedTestValues;
    }

    public void log() {
        if (Log.isLoggingOn()) {
            this.logOperations(GenInputsAbstract.log);
        }
    }

    public void logOperations(@UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown PrintStream out) {
        this.logOperations(new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8))));
    }

    public void logOperations(@UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Writer out) {
        try {
            out.write("Operations: (" + this.operations.size() + ")" + Globals.lineSep);
            for (TypedOperation t2 : this.operations) {
                out.write("  " + StringsPlume.toStringAndClass(t2.toString()));
                out.write(Globals.lineSep);
                out.flush();
            }
        }
        catch (IOException e) {
            throw new RandoopBug("Error while logging operations", e);
        }
    }

    public void dumpModel() {
        if (Log.isLoggingOn()) {
            this.dumpModel(GenInputsAbstract.log);
        }
    }

    public void dumpModel(@UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown PrintStream out) {
        this.dumpModel(new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8))));
    }

    public void dumpModel(@UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Writer out) {
        try {
            out.write(String.format("Model with hashcode %s:%n", this.hashCode()));
            out.write(String.format("  classTypes = %s%n", this.classTypes));
            out.write(String.format("  inputTypes = %s%n", this.inputTypes));
            out.write(String.format("  coveredClassesGoal = %s%n", this.coveredClassesGoal));
            out.write(String.format("  classLiteralMap = %s%n", this.classLiteralMap));
            out.write(String.format("  annotatedTestValues = %s%n", this.annotatedTestValues));
            out.write(String.format("  contracts = %s%n", this.contracts));
            out.write(String.format("  omitMethods = [%n", new Object[0]));
            for (Pattern p : this.omitMethods) {
                out.write(String.format("    %s%n", p));
            }
            out.write(String.format("  ]%n", new Object[0]));
            this.logOperations(out);
        }
        catch (IOException ioe) {
            throw new Error(ioe);
        }
    }

    private void addClassTypes(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate accessibility, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String> classnames, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String> coveredClassesGoalNames, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassNameErrorHandler errorHandler, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> literalsFileList) {
        Class<?> c;
        ReflectionManager mgr = new ReflectionManager(accessibility);
        mgr.add(new DeclarationExtractor(this.classTypes, reflectionPredicate));
        mgr.add(new TypeExtractor(this.inputTypes, accessibility));
        mgr.add(new TestValueExtractor(this.annotatedTestValues));
        mgr.add(new CheckRepExtractor(this.contracts));
        if (literalsFileList.contains("CLASSES")) {
            mgr.add(new ClassLiteralExtractor(this.classLiteralMap));
        }
        int succeeded = 0;
        for (String classname : classnames) {
            try {
                c = OperationModel.getClass(classname, errorHandler);
            }
            catch (RandoopClassNameError e) {
                throw new RandoopUsageError("Could not load class " + classname + ": " + e.getMessage());
            }
            if (c == null) continue;
            boolean classIsAccessible = accessibility.isAccessible(c);
            boolean hasAccessibleStaticMethod = false;
            if (!classIsAccessible) {
                for (Method m4 : c.getDeclaredMethods()) {
                    if (!Modifier.isStatic(m4.getModifiers()) || !accessibility.isAccessible(m4)) continue;
                    hasAccessibleStaticMethod = true;
                    break;
                }
                System.out.printf("Cannot instantiate non-accessible %s specified via --testclass or --classlist%s.%n", c, hasAccessibleStaticMethod ? "; will use its static methods" : "");
            }
            if (!classIsAccessible && !hasAccessibleStaticMethod) continue;
            try {
                mgr.apply(c);
                ++succeeded;
            }
            catch (Throwable e) {
                System.out.printf("Cannot get methods for %s specified via --testclass or --classlist due to exception:%n%s%n", c.getName(), UtilPlume.stackTraceToString(e));
            }
        }
        if (GenInputsAbstract.progressdisplay) {
            if (succeeded == classnames.size()) {
                System.out.printf("%nWill try to generate tests for %d classes.%n", succeeded);
            } else {
                System.out.printf("%nWill try to generate tests for %d out of %d classes.%n", succeeded, classnames.size());
            }
        }
        for (String classname : coveredClassesGoalNames) {
            c = OperationModel.getClass(classname, errorHandler);
            if (c == null || c.isInterface()) continue;
            this.coveredClassesGoal.add(c);
        }
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> getClass(@ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String classname, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassNameErrorHandler errorHandler) {
        try {
            return TypeNames.getTypeForName(classname);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            errorHandler.handle(classname, e);
        }
        catch (Throwable e) {
            if (e.getCause() != null) {
                e = e.getCause();
            }
            errorHandler.handle(classname, e);
        }
        return null;
    }

    private void addOperationsFromClasses(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate accessibility, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate, @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SpecificationCollection operationSpecifications) {
        Iterator<ClassOrInterfaceType> itor = this.classTypes.iterator();
        while (itor.hasNext()) {
            ClassOrInterfaceType classType = itor.next();
            Log.logPrintf("addOperationsFromClasses: classType=%s%n", classType);
            try {
                List<TypedOperation> oneClassOperations = OperationExtractor.operations(classType, reflectionPredicate, this.omitMethodsPredicate, accessibility, operationSpecifications);
                Log.logPrintf("addOperationsFromClasses: classType=%s%n", classType);
                for (TypedOperation op : oneClassOperations) {
                    Log.logPrintf("    %s%n", op);
                }
                this.operations.addAll(oneClassOperations);
            }
            catch (Throwable e) {
                System.out.printf("Removing %s from the classes under test due to problem extracting operations:%n%s%n", classType, UtilPlume.stackTraceToString(e));
                itor.remove();
            }
        }
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation> getOperationsFromFile(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path methodSignatures_file, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate accessibility, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SignatureParseException {
        ArrayList<TypedClassOperation> result = new ArrayList<TypedClassOperation>();
        if (methodSignatures_file == null) {
            return result;
        }
        try (EntryReader reader = new EntryReader(methodSignatures_file, "(//|#).*$", null);){
            for (String line : reader) {
                String sig = line.trim();
                if (sig.isEmpty()) continue;
                try {
                    TypedClassOperation operation = OperationModel.signatureToOperation(sig, accessibility, reflectionPredicate);
                    if (this.omitMethodsPredicate.shouldOmit(operation)) continue;
                    result.add(operation);
                }
                catch (FailedPredicateException e) {
                    System.out.printf("Ignoring %s that failed predicate: %s%n", sig, e.getMessage());
                }
            }
        }
        catch (IOException e) {
            throw new RandoopUsageError("Problem reading file " + Util.pathAndAbsolute(methodSignatures_file), e);
        }
        return result;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation signatureToOperation(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String signature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate accessibility, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SignatureParseException, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown FailedPredicateException {
        AccessibleObject accessibleObject = SignatureParser.parse(signature, accessibility, reflectionPredicate);
        if (accessibleObject == null) {
            throw new FailedPredicateException(String.format("accessibleObject is null for %s, typically due to predicates: %s, %s", signature, accessibility, reflectionPredicate));
        }
        if (accessibleObject instanceof Constructor) {
            return TypedOperation.forConstructor((Constructor)accessibleObject);
        }
        return TypedOperation.forMethod((Method)accessibleObject);
    }

    private void addObjectConstructor() {
        Constructor objectConstructor;
        try {
            objectConstructor = Object.class.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RandoopBug("unable to load java.lang.Object() constructor", e);
        }
        TypedClassOperation operation = TypedOperation.forConstructor(objectConstructor);
        this.classTypes.add(operation.getDeclaringType());
        this.operations.add(operation);
    }
}

