/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import randoop.condition.ExecutableSpecification;
import randoop.condition.SpecificationCollection;
import randoop.main.RandoopBug;
import randoop.operation.CallableOperation;
import randoop.operation.EnumConstant;
import randoop.operation.TypedClassOperation;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.plumelib.util.CollectionsPlume;
import randoop.org.plumelib.util.StringsPlume;
import randoop.reflection.AccessibilityPredicate;
import randoop.reflection.DefaultClassVisitor;
import randoop.reflection.OmitMethodsPredicate;
import randoop.reflection.ReflectionManager;
import randoop.reflection.ReflectionPredicate;
import randoop.types.ClassOrInterfaceType;
import randoop.types.NonParameterizedType;
import randoop.types.Substitution;
import randoop.types.TypeTuple;
import randoop.util.Log;

public class OperationExtractor
extends DefaultClassVisitor {
    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean debug = false;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType classType;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation> operations = new TreeSet<TypedOperation>();
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OmitMethodsPredicate omitPredicate;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate accessibilityPredicate;
    private final @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SpecificationCollection operationSpecifications;

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation> operations(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> clazz, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate accessibilityPredicate) {
        return OperationExtractor.operations(clazz, reflectionPredicate, OmitMethodsPredicate.NO_OMISSION, accessibilityPredicate, null);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation> operations(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType classType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate accessibilityPredicate) {
        return OperationExtractor.operations(classType, reflectionPredicate, OmitMethodsPredicate.NO_OMISSION, accessibilityPredicate, null);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation> operations(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType> classTypes, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate accessibilityPredicate) {
        return OperationExtractor.operations(classTypes, reflectionPredicate, OmitMethodsPredicate.NO_OMISSION, accessibilityPredicate, null);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation> operations(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> clazz, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OmitMethodsPredicate omitPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate accessibilityPredicate) {
        return OperationExtractor.operations(clazz, reflectionPredicate, omitPredicate, accessibilityPredicate, null);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation> operations(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType classType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OmitMethodsPredicate omitPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate accessibilityPredicate) {
        return OperationExtractor.operations(classType, reflectionPredicate, omitPredicate, accessibilityPredicate, null);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation> operations(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType> classTypes, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OmitMethodsPredicate omitPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate accessibilityPredicate) {
        return OperationExtractor.operations(classTypes, reflectionPredicate, omitPredicate, accessibilityPredicate, null);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation> operations(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> clazz, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OmitMethodsPredicate omitMethodsPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate accessibilityPredicate, @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SpecificationCollection operationSpecifications) {
        return OperationExtractor.operations(ClassOrInterfaceType.forClass(clazz), reflectionPredicate, omitMethodsPredicate, accessibilityPredicate, operationSpecifications);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation> operations(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType classType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OmitMethodsPredicate omitMethodsPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate accessibilityPredicate, @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SpecificationCollection operationSpecifications) {
        ReflectionManager mgr = new ReflectionManager(accessibilityPredicate);
        OperationExtractor extractor = new OperationExtractor(classType, reflectionPredicate, omitMethodsPredicate, accessibilityPredicate, operationSpecifications);
        mgr.apply(extractor, classType.getRuntimeClass());
        return new ArrayList<TypedOperation>(extractor.getOperations());
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation> operations(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType> classTypes, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OmitMethodsPredicate omitMethodsPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate accessibilityPredicate, @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SpecificationCollection operationSpecifications) {
        TreeSet<TypedOperation> result = new TreeSet<TypedOperation>();
        ReflectionManager mgr = new ReflectionManager(accessibilityPredicate);
        for (ClassOrInterfaceType classType : classTypes) {
            OperationExtractor extractor = new OperationExtractor(classType, reflectionPredicate, omitMethodsPredicate, accessibilityPredicate, operationSpecifications);
            mgr.apply(extractor, classType.getRuntimeClass());
            result.addAll(extractor.getOperations());
        }
        return new ArrayList<TypedOperation>(result);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType> classListToTypeList(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?>> classes) {
        return CollectionsPlume.mapList(ClassOrInterfaceType::forClass, classes);
    }

    public OperationExtractor(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType classType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OmitMethodsPredicate omitPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate accessibilityPredicate, @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SpecificationCollection operationSpecifications) {
        this.classType = classType;
        this.reflectionPredicate = reflectionPredicate;
        this.omitPredicate = omitPredicate;
        this.accessibilityPredicate = accessibilityPredicate;
        this.operationSpecifications = operationSpecifications;
    }

    public OperationExtractor(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType classType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate accessibilityPredicate) {
        this(classType, reflectionPredicate, OmitMethodsPredicate.NO_OMISSION, accessibilityPredicate, null);
    }

    public OperationExtractor(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType classType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OmitMethodsPredicate omitPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate accessibilityPredicate) {
        this(classType, reflectionPredicate, omitPredicate, accessibilityPredicate, null);
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation instantiateTypes(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation operation) {
        if (!this.classType.isGeneric() && operation.getDeclaringType().isGeneric()) {
            Substitution substitution = this.classType.getInstantiatingSubstitution(operation.getDeclaringType());
            if (substitution == null) {
                throw new RandoopBug(String.format("Type %s for operation %s is not a subtype of an instantiation of declaring class of method %s", this.classType, operation, operation.getDeclaringType()));
            }
            if ((operation = operation.substitute(substitution)) == null) {
                throw new RandoopBug("Instantiation of operation failed");
            }
        }
        return operation;
    }

    private void checkSubTypes(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation operation) {
        ClassOrInterfaceType declaringType = operation.getDeclaringType();
        if (!this.classType.isSubtypeOf(declaringType)) {
            throw new RandoopBug(String.format("Incompatible receiver type for operation %s:%n  %s%nis not a subtype of%n  %s", operation, StringsPlume.toStringAndClass(this.classType), StringsPlume.toStringAndClass(declaringType)));
        }
    }

    @Override
    public void visit(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Constructor<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> constructor) {
        if (debug) {
            Log.logPrintln("OperationExtractor.visit: constructor=" + constructor);
        }
        assert (constructor.getDeclaringClass().equals(this.classType.getRuntimeClass())) : "classType " + this.classType + " and declaring class " + constructor.getDeclaringClass().getName() + " should be same";
        if (!this.reflectionPredicate.test(constructor)) {
            return;
        }
        TypedClassOperation operation = this.instantiateTypes(TypedOperation.forConstructor(constructor));
        if (debug) {
            Log.logPrintf("OperationExtractor.visit: operation=%s for constructor %s%n", operation, constructor);
            Log.logPrintf("  omitPredicate=%s%n", StringsPlume.toStringAndClass(this.omitPredicate));
        }
        this.checkSubTypes(operation);
        if (!this.omitPredicate.shouldOmit(operation)) {
            ExecutableSpecification execSpec;
            if (this.operationSpecifications != null && !(execSpec = this.operationSpecifications.getExecutableSpecification(constructor)).isEmpty()) {
                operation.setExecutableSpecification(execSpec);
            }
            if (debug) {
                Log.logPrintln("OperationExtractor.visit: add operation " + StringsPlume.toStringAndClass(operation));
            }
            this.operations.add(operation);
        } else if (debug) {
            Log.logPrintf("OperationExtractor.visit: shouldOmit failed %s%n  %s%n", StringsPlume.toStringAndClass(operation), this.omitPredicate);
        }
    }

    @Override
    public void visit(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method method) {
        ExecutableSpecification execSpec;
        int declaringClassMods;
        if (debug) {
            Log.logPrintln("OperationExtractor.visit: method=" + method);
        }
        if (!this.reflectionPredicate.test(method)) {
            return;
        }
        TypedClassOperation operation = this.instantiateTypes(TypedOperation.forMethod(method));
        if (debug) {
            Log.logPrintln("OperationExtractor.visit: operation=" + operation);
        }
        this.checkSubTypes(operation);
        if (operation.isStatic() && !Modifier.isPublic(declaringClassMods = method.getDeclaringClass().getModifiers() & Modifier.classModifiers())) {
            operation = operation.getOperationForType(this.classType);
            if (debug) {
                Log.logPrintln("OperationExtractor.visit: operation changed to " + operation);
            }
        }
        if (debug) {
            Log.logPrintf("  omitPredicate=%s%n", StringsPlume.toStringAndClass(this.omitPredicate));
        }
        if (this.omitPredicate.shouldOmit(operation.getOperationForType(this.classType))) {
            Log.logPrintln("omitPreditate omits " + operation.getOperationForType(this.classType));
            return;
        }
        if (this.operationSpecifications != null && !(execSpec = this.operationSpecifications.getExecutableSpecification(method)).isEmpty()) {
            operation.setExecutableSpecification(execSpec);
        }
        if (debug) {
            Log.logPrintln("OperationExtractor.visit: add operation " + operation);
        }
        this.operations.add(operation);
    }

    @Override
    public void visit(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Field field) {
        TypedClassOperation operation;
        assert (field.getDeclaringClass().isAssignableFrom(this.classType.getRuntimeClass())) : "classType " + this.classType + " should be assignable from " + field.getDeclaringClass().getName();
        if (!this.reflectionPredicate.test(field)) {
            return;
        }
        ClassOrInterfaceType declaringType = ClassOrInterfaceType.forClass(field.getDeclaringClass());
        int mods = field.getModifiers() & Modifier.fieldModifiers();
        if (!this.accessibilityPredicate.isAccessible(field.getDeclaringClass())) {
            if (Modifier.isStatic(mods) && Modifier.isFinal(mods)) {
                return;
            }
            if (!declaringType.isGeneric() || !this.classType.isInstantiationOf(declaringType)) {
                declaringType = this.classType;
            }
        }
        TypedClassOperation getter = this.instantiateTypes(TypedOperation.createGetterForField(field, declaringType));
        this.checkSubTypes(getter);
        if (getter != null) {
            this.operations.add(getter);
        }
        if (!Modifier.isFinal(mods) && (operation = this.instantiateTypes(TypedOperation.createSetterForField(field, declaringType))) != null) {
            this.operations.add(operation);
        }
    }

    @Override
    public void visit(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Enum<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @Signed @SignednessBottom @SignatureUnknown @SignatureBottom ?> e) {
        NonParameterizedType enumType = NonParameterizedType.forClass(e.getDeclaringClass());
        assert (!enumType.isGeneric()) : "type of enum class cannot be generic";
        EnumConstant op = new EnumConstant(e);
        TypedClassOperation operation = new TypedClassOperation((CallableOperation)op, enumType, new TypeTuple(), enumType);
        this.operations.add(operation);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation> getOperations() {
        return this.operations;
    }
}

