/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import randoop.operation.TypedClassOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.reflection.RawSignature;
import randoop.types.ClassOrInterfaceType;
import randoop.util.Log;

public class OmitMethodsPredicate {
    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean logOmit = false;
    public static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OmitMethodsPredicate NO_OMISSION = new OmitMethodsPredicate(new ArrayList<Pattern>(0));
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Pattern> omitPatterns;

    public OmitMethodsPredicate(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Pattern> omitPatterns) {
        this.omitPatterns = new ArrayList<Pattern>(omitPatterns);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean shouldOmit(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation operation) {
        if (logOmit) {
            Log.logPrintf("shouldOmit: testing %s [%s]%n", operation, operation.getClass());
        }
        if (this.omitPatterns.isEmpty()) {
            return false;
        }
        if (operation.isConstructorCall()) {
            return this.shouldOmitConstructor(operation);
        }
        if (operation.isMethodCall()) {
            return this.shouldOmitMethod(operation);
        }
        return false;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean shouldOmitConstructor(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation operation) {
        return this.shouldOmitExact(operation);
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean shouldOmitMethod(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation operation) {
        if (logOmit) {
            Log.logPrintf("%nshouldOmitMethod(%s)%n", operation);
        }
        RawSignature signature = operation.getRawSignature();
        for (ClassOrInterfaceType type : operation.getDeclaringType().getAllSupertypesInclusive()) {
            TypedClassOperation superTypeOperation;
            boolean exists;
            if (logOmit) {
                Log.logPrintf("shouldOmit looking in %s for %s%n", type, signature.getName());
            }
            if (logOmit) {
                Log.logPrintf(" operation = %s%n signature = %s%n signature.getName() = %s%n signature.getClassname() = %s%n type = %s [%s]%n type.getRuntimeClass() = %s%n type.getRuntimeClass().getSimpleName()) = %s%n type.getRuntimeClass().getname()) = %s%n type.getRuntimeClass().getTypeName()) = %s%n", operation, signature, signature.getName(), signature.getClassname(), type, type.getClass(), type.getRuntimeClass(), type.getRuntimeClass().getSimpleName(), type.getRuntimeClass().getName(), type.getRuntimeClass().getTypeName());
            }
            try {
                type.getRuntimeClass().getMethod(signature.getName(), signature.getParameterTypes());
                exists = true;
            }
            catch (NoSuchMethodException e) {
                if (logOmit) {
                    Log.logPrintf("no method %s in %stype %s%n", signature, type == operation.getDeclaringType() ? "" : "super", type.getRuntimeClass().getSimpleName());
                }
                exists = false;
            }
            if (!exists || !this.shouldOmitExact(superTypeOperation = operation.getOperationForType(type))) continue;
            return true;
        }
        return false;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean shouldOmitExact(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation operation) {
        if (logOmit) {
            Log.logPrintf("shouldOmitExact(%s)%n", operation);
        }
        if (!operation.isConstructorCall() && !operation.isMethodCall()) {
            throw new IllegalArgumentException(String.format("operation = %s [%s]", operation, operation.getClass()));
        }
        if (this.omitPatterns.isEmpty()) {
            return false;
        }
        String signature = operation.getRawSignature().toString();
        for (Pattern pattern : this.omitPatterns) {
            boolean result = pattern.matcher(signature).find();
            if (logOmit) {
                Log.logPrintf("shouldOmitExact(%s): \"%s\".matches(%s) => %s%n", operation, pattern, signature, result);
            }
            if (!result) continue;
            return true;
        }
        return false;
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return "OmitMethodsPredicate: " + this.omitPatterns;
    }
}

