/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import randoop.Globals;
import randoop.operation.NonreceiverTerm;
import randoop.operation.OperationParseException;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.ClassGetName;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.reflection.TypeNames;
import randoop.sequence.Sequence;
import randoop.sequence.Variable;
import randoop.types.ClassOrInterfaceType;
import randoop.util.MultiMap;
import randoop.util.RecordListReader;
import randoop.util.RecordProcessor;

public class LiteralFileReader {
    private LiteralFileReader() {
        throw new Error("Do not instantiate");
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MultiMap<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> parse(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String inFile) {
        final MultiMap<ClassOrInterfaceType, Sequence> map = new MultiMap<ClassOrInterfaceType, Sequence>();
        RecordProcessor processor = new RecordProcessor(){

            @Override
            public void processRecord(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> lines) {
                if (lines.size() < 1 || !lines.get(0).trim().toUpperCase(Locale.getDefault()).equals("CLASSNAME")) {
                    LiteralFileReader.throwRecordSyntaxError("record does not begin with \"CLASSNAME\"", lines, 0);
                }
                if (lines.size() < 2) {
                    LiteralFileReader.throwRecordSyntaxError("class name missing", lines, 1);
                }
                Class<?> cls = null;
                try {
                    @ClassGetName String className = lines.get(1);
                    cls = TypeNames.getTypeForName(className);
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    LiteralFileReader.throwRecordSyntaxError(e);
                }
                assert (cls != null);
                ClassOrInterfaceType classType = ClassOrInterfaceType.forClass(cls);
                if (lines.size() < 3 || !lines.get(2).trim().toUpperCase(Locale.getDefault()).equals("LITERALS")) {
                    LiteralFileReader.throwRecordSyntaxError("Missing field \"LITERALS\"", lines, 2);
                }
                for (int i = 3; i < lines.size(); ++i) {
                    try {
                        TypedOperation operation = NonreceiverTerm.parse(lines.get(i));
                        map.add(classType, new Sequence().extend(operation, new ArrayList<Variable>(0)));
                        continue;
                    }
                    catch (OperationParseException e) {
                        LiteralFileReader.throwRecordSyntaxError(e);
                    }
                }
            }
        };
        RecordListReader reader = new RecordListReader("CLASSLITERALS", processor);
        reader.parse(inFile);
        return map;
    }

    private static void throwRecordSyntaxError(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Throwable e) {
        throw new Error(e);
    }

    private static void throwRecordSyntaxError(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String string, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> lines, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int i) {
        StringBuilder b = new StringBuilder();
        b.append("RECORD PROCESSING ERROR: ").append(string).append(Globals.lineSep);
        LiteralFileReader.appendRecord(b, lines, i);
        throw new Error(b.toString());
    }

    private static void appendRecord(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown StringBuilder b, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> lines, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int i) {
        b.append("INVALID RECORD (error is at index ").append(i).append("):").append(Globals.lineSep);
        b.append("------------------------------").append(Globals.lineSep);
        for (String l : lines) {
            b.append("   ").append(l).append(Globals.lineSep);
        }
        b.append("------------------------------").append(Globals.lineSep);
    }
}

