/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import randoop.CheckRep;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.reflection.ReflectionPredicate;
import randoop.util.Log;

public class DefaultReflectionPredicate
implements ReflectionPredicate {
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> omitFields;

    public DefaultReflectionPredicate() {
        this(null);
    }

    public DefaultReflectionPredicate(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> omitFields) {
        this.omitFields = omitFields;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean test(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> c) {
        return !c.isAnonymousClass();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean test(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method m4) {
        if (this.isRandoopInstrumentation(m4)) {
            return false;
        }
        Class<?>[] paramTypes = m4.getParameterTypes();
        if (m4.getName().equals("main") && paramTypes.length == 1 && paramTypes[0].isArray() && paramTypes[0].getComponentType().equals(String.class)) {
            Log.logPrintf("Will not use main method: %s%n", m4);
            return false;
        }
        if (m4.isBridge()) {
            if (this.discardBridge(m4)) {
                return false;
            }
            Log.logPrintf("Using visibility bridge method: %s%n", m4);
        }
        if (!m4.isBridge() && m4.isSynthetic()) {
            Log.logPrintf("Will not use synthetic method: %s%n", m4);
            return false;
        }
        if (m4.getDeclaringClass().equals(Object.class)) {
            return m4.getName().equals("getClass");
        }
        if (m4.getDeclaringClass().equals(Thread.class)) {
            return false;
        }
        if (m4.getAnnotation(CheckRep.class) != null) {
            return false;
        }
        String reason = this.doNotUseSpecialCase(m4);
        if (reason != null) {
            Log.logPrintf("Will not use: %s%n  reason: %s%n", m4, reason);
            return false;
        }
        return true;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isRandoopInstrumentation(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method m4) {
        return m4.getName().contains("randoop_");
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean discardBridge(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method m4) {
        if (!this.isVisibilityBridge(m4)) {
            Log.logPrintf("Will not use bridge method: %s%n", m4);
            return true;
        }
        return m4.getDeclaringClass().isAnonymousClass() && m4.getDeclaringClass().getEnclosingClass() != null && m4.getDeclaringClass().getEnclosingClass().isEnum();
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isVisibilityBridge(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method m4) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Error {
        Class<?> c = m4.getDeclaringClass();
        if (!this.isPublic(c)) {
            return false;
        }
        for (c = c.getSuperclass(); c != null; c = c.getSuperclass()) {
            if (this.isPublic(c) || !this.definesNonBridgeMethod(c, m4)) continue;
            return true;
        }
        return false;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean definesNonBridgeMethod(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> c, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method goalMethod) {
        Method defined;
        try {
            defined = c.getDeclaredMethod(goalMethod.getName(), goalMethod.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            String msg = "Cannot access method " + goalMethod.getName() + " in class " + c.getCanonicalName();
            throw new Error(msg);
        }
        return !defined.isBridge();
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isPublic(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> c) {
        return Modifier.isPublic(c.getModifiers() & Modifier.classModifiers());
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String doNotUseSpecialCase(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method m4) {
        String mName = m4.getName().intern();
        Class<?> mClass = m4.getDeclaringClass();
        if (!mClass.isAnonymousClass() && mClass.getCanonicalName().equals("java.lang.Enum") && mName == "compareTo" && m4.getParameterTypes().length == 1 && m4.getParameterTypes()[0].equals(Enum.class)) {
            return "Enum compareTo method has restrictions on argument types";
        }
        if (mName == "randomUUID") {
            return "randomUUID() is nondeterministic";
        }
        if (mName == "hashCode" && !mClass.equals(String.class)) {
            return "hashCode may be nondeterministic";
        }
        if (mName == "deepHashCode" && mClass.equals(Arrays.class)) {
            return "deepHashCode is nondeterministic because hashCode() is";
        }
        if (mName == "getAvailableLocales") {
            return "getAvailableLocales differs too much between JDK installations";
        }
        if (mName == "fillInStackTrace" || mName == "getCause" || mName == "getLocalizedMessage" || mName == "getMessage" || mName == "getStackTrace" || mName == "initCause" || mName == "printStackTrace" || mName == "setStackTrace") {
            return "Randoop avoids exploring Exception class methods, to avoid nontermination.";
        }
        return null;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean test(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Constructor<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> c) {
        if (c.isSynthetic()) {
            for (Class<?> p : c.getParameterTypes()) {
                if (!p.isAnonymousClass()) continue;
                return false;
            }
        }
        return !Modifier.isAbstract(c.getDeclaringClass().getModifiers());
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean test(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Field f) {
        boolean result;
        if (this.isRandoopInstrumentation(f)) {
            return false;
        }
        String name = f.getDeclaringClass().getName() + "." + f.getName();
        if (this.omitFields == null) {
            Log.logPrintf("Field '%s' included, no omit-field arguments%n", name);
            return true;
        }
        boolean bl = result = !this.omitFields.contains(name);
        if (result) {
            Log.logPrintf("Field '%s' does not match omit-field, including field%n", name);
        } else {
            Log.logPrintf("Field '%s' matches omit-field, not including field%n", name);
        }
        return result;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isRandoopInstrumentation(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Field f) {
        return f.getName().contains("randoop_");
    }
}

