/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import randoop.CheckRep;
import randoop.contract.CheckRepContract;
import randoop.main.GenInputsAbstract;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.reflection.DefaultClassVisitor;
import randoop.test.ContractSet;

class CheckRepExtractor
extends DefaultClassVisitor {
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ContractSet contracts;

    CheckRepExtractor(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ContractSet contracts) {
        this.contracts = contracts;
    }

    @Override
    public void visit(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method m4) {
        if (m4.getAnnotation(CheckRep.class) != null) {
            if (Modifier.isStatic(m4.getModifiers())) {
                String msg = "RANDOOP ANNOTATION ERROR: Expected @CheckRep-annotated method " + m4.getName() + " in class " + m4.getDeclaringClass() + " to be an instance method, but it is declared static.";
                throw new RuntimeException(msg);
            }
            if (m4.getParameterTypes().length > 0) {
                String msg = "RANDOOP ANNOTATION ERROR: Expected @CheckRep-annotated method " + m4.getName() + " in class " + m4.getDeclaringClass() + " to declare no parameters but it does (method signature:" + m4.toString() + ").";
                throw new RuntimeException(msg);
            }
            if (!m4.getReturnType().equals(Boolean.TYPE) && !m4.getReturnType().equals(Void.TYPE)) {
                String msg = "RANDOOP ANNOTATION ERROR: Expected @CheckRep-annotated method " + m4.getName() + " in class " + m4.getDeclaringClass() + " to have void or boolean return type but it does not (method signature:" + m4.toString() + ").";
                throw new RuntimeException(msg);
            }
            if (GenInputsAbstract.progressdisplay) {
                CheckRepExtractor.printDetectedAnnotatedCheckRepMethod(m4);
            }
            this.contracts.add(new CheckRepContract(m4));
        }
    }

    private static void printDetectedAnnotatedCheckRepMethod(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method m4) {
        String msg = "ANNOTATION: Detected @CheckRep-annotated method \"" + m4.toString() + "\". Will use it to check rep invariant of class " + m4.getDeclaringClass().getCanonicalName() + " during generation.";
        System.out.println(msg);
    }
}

