/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.commons.io.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import randoop.org.apache.commons.io.Charsets;
import randoop.org.apache.commons.io.FileUtils;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.initialization.qual.UnderInitialization;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.nullness.qual.RequiresNonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class LockableFileWriter
extends Writer {
    private static final @UnknownKeyFor @NonNull @Initialized String LCK = ".lck";
    private final @UnknownKeyFor @NonNull @Initialized Writer out;
    private final @UnknownKeyFor @NonNull @Initialized File lockFile;

    public LockableFileWriter(@UnknownKeyFor @NonNull @Initialized String fileName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(fileName, false, null);
    }

    public LockableFileWriter(@UnknownKeyFor @NonNull @Initialized String fileName, @UnknownKeyFor @NonNull @Initialized boolean append) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(fileName, append, null);
    }

    public LockableFileWriter(@UnknownKeyFor @NonNull @Initialized String fileName, @UnknownKeyFor @NonNull @Initialized boolean append, @Nullable @UnknownKeyFor @Initialized String lockDir) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(new File(fileName), append, lockDir);
    }

    public LockableFileWriter(@UnknownKeyFor @NonNull @Initialized File file) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(file, false, null);
    }

    public LockableFileWriter(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized boolean append) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(file, append, null);
    }

    @Deprecated
    public LockableFileWriter(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized boolean append, @Nullable @UnknownKeyFor @Initialized String lockDir) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(file, Charset.defaultCharset(), append, lockDir);
    }

    public LockableFileWriter(@UnknownKeyFor @NonNull @Initialized File file, @Nullable @UnknownKeyFor @Initialized Charset charset) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(file, charset, false, null);
    }

    public LockableFileWriter(@UnknownKeyFor @NonNull @Initialized File file, @Nullable @UnknownKeyFor @Initialized String charsetName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(file, charsetName, false, null);
    }

    public LockableFileWriter(@UnknownKeyFor @NonNull @Initialized File file, @Nullable @UnknownKeyFor @Initialized Charset charset, @UnknownKeyFor @NonNull @Initialized boolean append, @Nullable @UnknownKeyFor @Initialized String lockDir) throws @UnknownKeyFor @NonNull @Initialized IOException {
        file = file.getAbsoluteFile();
        if (file.getParentFile() != null) {
            FileUtils.forceMkdir(file.getParentFile());
        }
        if (file.isDirectory()) {
            throw new IOException("File specified is a directory");
        }
        if (lockDir == null) {
            lockDir = System.getProperty("java.io.tmpdir");
        }
        File lockDirFile = new File(lockDir);
        FileUtils.forceMkdir(lockDirFile);
        this.testLockDir(lockDirFile);
        this.lockFile = new File(lockDirFile, file.getName() + LCK);
        this.createLock();
        this.out = this.initWriter(file, charset, append);
    }

    public LockableFileWriter(@UnknownKeyFor @NonNull @Initialized File file, @Nullable @UnknownKeyFor @Initialized String charsetName, @UnknownKeyFor @NonNull @Initialized boolean append, @Nullable @UnknownKeyFor @Initialized String lockDir) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(file, Charsets.toCharset(charsetName), append, lockDir);
    }

    private void testLockDir(@UnderInitialization(value=Writer.class) LockableFileWriter this, @UnknownKeyFor @NonNull @Initialized File lockDir) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (!lockDir.exists()) {
            throw new IOException("Could not find lockDir: " + lockDir.getAbsolutePath());
        }
        if (!lockDir.canWrite()) {
            throw new IOException("Could not write to lockDir: " + lockDir.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresNonNull(value={"lockFile"})
    private void createLock(@UnderInitialization(value=Writer.class) LockableFileWriter this) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Class<LockableFileWriter> clazz = LockableFileWriter.class;
        synchronized (LockableFileWriter.class) {
            if (!this.lockFile.createNewFile()) {
                throw new IOException("Can't write file, lock " + this.lockFile.getAbsolutePath() + " exists");
            }
            this.lockFile.deleteOnExit();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized Writer initWriter(@UnderInitialization(value=Writer.class) LockableFileWriter this, @UnknownKeyFor @NonNull @Initialized File file, @Nullable @UnknownKeyFor @Initialized Charset charset, @UnknownKeyFor @NonNull @Initialized boolean append) throws @UnknownKeyFor @NonNull @Initialized IOException {
        boolean fileExistedAlready = file.exists();
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsolutePath(), append), Charsets.toCharset(charset));
        }
        catch (IOException | RuntimeException ex) {
            FileUtils.deleteQuietly(this.lockFile);
            if (!fileExistedAlready) {
                FileUtils.deleteQuietly(file);
            }
            throw ex;
        }
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.out.close();
        }
        finally {
            this.lockFile.delete();
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized int idx) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out.write(idx);
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] chr) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out.write(chr);
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] chr, @UnknownKeyFor @NonNull @Initialized int st, @UnknownKeyFor @NonNull @Initialized int end) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out.write(chr, st, end);
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized String str) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out.write(str);
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized String str, @UnknownKeyFor @NonNull @Initialized int st, @UnknownKeyFor @NonNull @Initialized int end) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out.write(str, st, end);
    }

    @Override
    public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out.flush();
    }
}

