/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.commons.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import randoop.org.apache.commons.io.filefilter.FileFilterUtils;
import randoop.org.apache.commons.io.filefilter.IOFileFilter;
import randoop.org.apache.commons.io.filefilter.TrueFileFilter;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class DirectoryWalker<@UnknownKeyFor T> {
    private final @Nullable @UnknownKeyFor @Initialized FileFilter filter;
    private final @UnknownKeyFor @NonNull @Initialized int depthLimit;

    protected DirectoryWalker() {
        this(null, -1);
    }

    protected DirectoryWalker(@Nullable @UnknownKeyFor @Initialized FileFilter filter, @UnknownKeyFor @NonNull @Initialized int depthLimit) {
        this.filter = filter;
        this.depthLimit = depthLimit;
    }

    protected DirectoryWalker(@Nullable @UnknownKeyFor @Initialized IOFileFilter directoryFilter, @Nullable @UnknownKeyFor @Initialized IOFileFilter fileFilter, @UnknownKeyFor @NonNull @Initialized int depthLimit) {
        if (directoryFilter == null && fileFilter == null) {
            this.filter = null;
        } else {
            directoryFilter = directoryFilter != null ? directoryFilter : TrueFileFilter.TRUE;
            fileFilter = fileFilter != null ? fileFilter : TrueFileFilter.TRUE;
            directoryFilter = FileFilterUtils.makeDirectoryOnly(directoryFilter);
            fileFilter = FileFilterUtils.makeFileOnly(fileFilter);
            this.filter = FileFilterUtils.or(directoryFilter, fileFilter);
        }
        this.depthLimit = depthLimit;
    }

    protected final void walk(@UnknownKeyFor @NonNull @Initialized File startDirectory, @UnknownKeyFor @NonNull @Initialized Collection<T> results) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Objects.requireNonNull(startDirectory, "startDirectory");
        try {
            this.handleStart(startDirectory, results);
            this.walk(startDirectory, 0, results);
            this.handleEnd(results);
        }
        catch (CancelException cancel) {
            this.handleCancelled(startDirectory, results, cancel);
        }
    }

    private void walk(@UnknownKeyFor @NonNull @Initialized File directory, @UnknownKeyFor @NonNull @Initialized int depth, @UnknownKeyFor @NonNull @Initialized Collection<T> results) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.checkIfCancelled(directory, depth, results);
        if (this.handleDirectory(directory, depth, results)) {
            this.handleDirectoryStart(directory, depth, results);
            int childDepth = depth + 1;
            if (this.depthLimit < 0 || childDepth <= this.depthLimit) {
                this.checkIfCancelled(directory, depth, results);
                File @Nullable [] childFiles = this.filter == null ? directory.listFiles() : directory.listFiles(this.filter);
                childFiles = this.filterDirectoryContents(directory, depth, childFiles);
                if (childFiles == null) {
                    this.handleRestricted(directory, childDepth, results);
                } else {
                    for (File childFile : childFiles) {
                        if (childFile.isDirectory()) {
                            this.walk(childFile, childDepth, results);
                            continue;
                        }
                        this.checkIfCancelled(childFile, childDepth, results);
                        this.handleFile(childFile, childDepth, results);
                        this.checkIfCancelled(childFile, childDepth, results);
                    }
                }
            }
            this.handleDirectoryEnd(directory, depth, results);
        }
        this.checkIfCancelled(directory, depth, results);
    }

    protected final void checkIfCancelled(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized int depth, @UnknownKeyFor @NonNull @Initialized Collection<T> results) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.handleIsCancelled(file, depth, results)) {
            throw new CancelException(file, depth);
        }
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean handleIsCancelled(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized int depth, @UnknownKeyFor @NonNull @Initialized Collection<T> results) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return false;
    }

    protected void handleCancelled(@UnknownKeyFor @NonNull @Initialized File startDirectory, @UnknownKeyFor @NonNull @Initialized Collection<T> results, @UnknownKeyFor @NonNull @Initialized CancelException cancel) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw cancel;
    }

    protected void handleStart(@UnknownKeyFor @NonNull @Initialized File startDirectory, @UnknownKeyFor @NonNull @Initialized Collection<T> results) throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean handleDirectory(@UnknownKeyFor @NonNull @Initialized File directory, @UnknownKeyFor @NonNull @Initialized int depth, @UnknownKeyFor @NonNull @Initialized Collection<T> results) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return true;
    }

    protected void handleDirectoryStart(@UnknownKeyFor @NonNull @Initialized File directory, @UnknownKeyFor @NonNull @Initialized int depth, @UnknownKeyFor @NonNull @Initialized Collection<T> results) throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    protected @UnknownKeyFor @NonNull @Initialized File @Nullable @UnknownKeyFor @Initialized [] filterDirectoryContents(@UnknownKeyFor @NonNull @Initialized File directory, @UnknownKeyFor @NonNull @Initialized int depth, File ... files) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return files;
    }

    protected void handleFile(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized int depth, @UnknownKeyFor @NonNull @Initialized Collection<T> results) throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    protected void handleRestricted(@UnknownKeyFor @NonNull @Initialized File directory, @UnknownKeyFor @NonNull @Initialized int depth, @UnknownKeyFor @NonNull @Initialized Collection<T> results) throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    protected void handleDirectoryEnd(@UnknownKeyFor @NonNull @Initialized File directory, @UnknownKeyFor @NonNull @Initialized int depth, @UnknownKeyFor @NonNull @Initialized Collection<T> results) throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    protected void handleEnd(@UnknownKeyFor @NonNull @Initialized Collection<T> results) throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    public static class CancelException
    extends IOException {
        private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 1347339620135041008L;
        private final @UnknownKeyFor @NonNull @Initialized File file;
        private final @UnknownKeyFor @NonNull @Initialized int depth;

        public CancelException(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized int depth) {
            this("Operation Cancelled", file, depth);
        }

        public CancelException(@UnknownKeyFor @NonNull @Initialized String message, @UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized int depth) {
            super(message);
            this.file = file;
            this.depth = depth;
        }

        public @UnknownKeyFor @NonNull @Initialized File getFile() {
            return this.file;
        }

        public @UnknownKeyFor @NonNull @Initialized int getDepth() {
            return this.depth;
        }
    }
}

