/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import randoop.org.apache.bcel.classfile.Attribute;
import randoop.org.apache.bcel.classfile.ConstantPool;
import randoop.org.apache.bcel.classfile.Utility;
import randoop.org.apache.bcel.classfile.Visitor;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.Interned;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public final class ModuleMainClass
extends Attribute {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int mainClassIndex;

    public ModuleMainClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ModuleMainClass c) {
        this(c.getNameIndex(), c.getLength(), c.getHostClassIndex(), c.getConstantPool());
    }

    public ModuleMainClass(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int mainClassIndex, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool) {
        super((byte)26, name_index, length, constantPool);
        this.mainClassIndex = mainClassIndex;
    }

    ModuleMainClass(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int nameIndex, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(nameIndex, length, 0, constantPool);
        this.mainClassIndex = input.readUnsignedShort();
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitModuleMainClass(this);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.dump(file);
        file.writeShort(this.mainClassIndex);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getHostClassIndex() {
        return this.mainClassIndex;
    }

    public void setHostClassIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int mainClassIndex) {
        this.mainClassIndex = mainClassIndex;
    }

    @Override
    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("ModuleMainClass: ");
        String class_name = super.getConstantPool().getConstantString(this.mainClassIndex, (byte)7);
        buf.append(Utility.compactClassName(class_name, false));
        return buf.toString();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool _constant_pool) {
        ModuleMainClass c = (ModuleMainClass)this.clone();
        c.setConstantPool(_constant_pool);
        return c;
    }
}

