/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import randoop.org.apache.bcel.classfile.ConstantPool;
import randoop.org.apache.bcel.classfile.ConstantUtf8;
import randoop.org.apache.bcel.classfile.Node;
import randoop.org.apache.bcel.classfile.Utility;
import randoop.org.apache.bcel.classfile.Visitor;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.Interned;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public final class InnerClass
implements Cloneable,
Node {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int innerClassIndex;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int outerClassIndex;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int innerNameIndex;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int innerAccessFlags;

    public InnerClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InnerClass c) {
        this(c.getInnerClassIndex(), c.getOuterClassIndex(), c.getInnerNameIndex(), c.getInnerAccessFlags());
    }

    InnerClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort());
    }

    public InnerClass(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int innerClassIndex, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int outerClassIndex, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int innerNameIndex, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int innerAccessFlags) {
        this.innerClassIndex = innerClassIndex;
        this.outerClassIndex = outerClassIndex;
        this.innerNameIndex = innerNameIndex;
        this.innerAccessFlags = innerAccessFlags;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitInnerClass(this);
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeShort(this.innerClassIndex);
        file.writeShort(this.outerClassIndex);
        file.writeShort(this.innerNameIndex);
        file.writeShort(this.innerAccessFlags);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getInnerAccessFlags() {
        return this.innerAccessFlags;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getInnerClassIndex() {
        return this.innerClassIndex;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getInnerNameIndex() {
        return this.innerNameIndex;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getOuterClassIndex() {
        return this.outerClassIndex;
    }

    public void setInnerAccessFlags(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int innerAccessFlags) {
        this.innerAccessFlags = innerAccessFlags;
    }

    public void setInnerClassIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int innerClassIndex) {
        this.innerClassIndex = innerClassIndex;
    }

    public void setInnerNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int innerNameIndex) {
        this.innerNameIndex = innerNameIndex;
    }

    public void setOuterClassIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int outerClassIndex) {
        this.outerClassIndex = outerClassIndex;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return "InnerClass(" + this.innerClassIndex + ", " + this.outerClassIndex + ", " + this.innerNameIndex + ", " + this.innerAccessFlags + ")";
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool) {
        String outer_class_name;
        String inner_class_name = constantPool.getConstantString(this.innerClassIndex, (byte)7);
        inner_class_name = Utility.compactClassName(inner_class_name, false);
        if (this.outerClassIndex != 0) {
            outer_class_name = constantPool.getConstantString(this.outerClassIndex, (byte)7);
            outer_class_name = " of class " + Utility.compactClassName(outer_class_name, false);
        } else {
            outer_class_name = "";
        }
        String inner_name = this.innerNameIndex != 0 ? ((ConstantUtf8)constantPool.getConstant(this.innerNameIndex, (byte)1)).getBytes() : "(anonymous)";
        String access = Utility.accessToString(this.innerAccessFlags, true);
        access = access.isEmpty() ? "" : access + " ";
        return "  " + access + inner_name + "=class " + inner_class_name + outer_class_name;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InnerClass copy() {
        try {
            return (InnerClass)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

