/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import randoop.ExecutionOutcome;
import randoop.compile.SequenceCompiler;
import randoop.condition.ExecutableSpecification;
import randoop.condition.ExpectedOutcomeTable;
import randoop.condition.SpecificationTranslator;
import randoop.condition.specification.Guard;
import randoop.condition.specification.Identifiers;
import randoop.condition.specification.OperationSignature;
import randoop.condition.specification.OperationSpecification;
import randoop.condition.specification.Postcondition;
import randoop.condition.specification.Precondition;
import randoop.condition.specification.Property;
import randoop.condition.specification.ThrowsCondition;
import randoop.field.AccessibleField;
import randoop.operation.ArrayCreation;
import randoop.operation.ArrayElementSet;
import randoop.operation.CallableOperation;
import randoop.operation.ConstructorCall;
import randoop.operation.FieldGet;
import randoop.operation.FieldSet;
import randoop.operation.InitializedArrayCreation;
import randoop.operation.MethodCall;
import randoop.operation.NonreceiverTerm;
import randoop.operation.Operation;
import randoop.operation.TypedClassOperation;
import randoop.operation.TypedClassOperationWithCast;
import randoop.operation.TypedTermOperation;
import randoop.operation.UncheckedCast;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.ClassGetName;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.CollectionsPlume;
import randoop.org.plumelib.util.StringsPlume;
import randoop.reflection.ReflectionPredicate;
import randoop.sequence.Variable;
import randoop.types.ArrayType;
import randoop.types.ClassOrInterfaceType;
import randoop.types.GenericClassType;
import randoop.types.InstantiatedType;
import randoop.types.JavaTypes;
import randoop.types.Substitution;
import randoop.types.TypeTuple;
import randoop.types.TypeVariable;

public abstract class TypedOperation
implements Operation,
Comparable<TypedOperation> {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown CallableOperation operation;
    protected final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown randoop.types.Type outputType;
    private @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSpecification execSpec;
    public static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Comparator<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RankedTypeOperation> compareRankedTypeOperation = (t2, t1) -> {
        int rankingComparison = Double.valueOf(t2.ranking).compareTo(t1.ranking);
        if (rankingComparison != 0) {
            return rankingComparison;
        }
        return t2.operation.getName().compareTo(t1.operation.getName());
    };

    TypedOperation(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown CallableOperation operation, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown randoop.types.Type outputType, @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSpecification execSpec) {
        this.operation = operation;
        this.inputTypes = inputTypes;
        this.outputType = outputType;
        this.execSpec = execSpec;
        if (operation.isMethodCall()) {
            MethodCall methodCall = (MethodCall)operation;
            Method m4 = methodCall.getMethod();
            Class<?> declaringClass = m4.getDeclaringClass();
            String className = declaringClass.getName();
            OperationSpecification OperationSpec = TypedOperation.specificationFromAnnotations(m4, className);
            try (SequenceCompiler compiler = new SequenceCompiler();){
                ExecutableSpecification annoSpec = SpecificationTranslator.createExecutableSpecification(m4, OperationSpec, compiler);
                this.execSpec = this.execSpec == null ? annoSpec : ExecutableSpecification.merge(annoSpec, this.execSpec);
            }
            catch (Exception e) {
                System.out.println("Exception occurred while creating and merging ExecutableSpecification");
            }
        }
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSpecification specificationFromAnnotations(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method method, @ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String className) {
        String methodName = method.getName();
        Parameter[] parameters = method.getParameters();
        List<String> parameterNames = CollectionsPlume.mapList(Parameter::getName, method.getParameters());
        List<@ClassGetName String> parameterTypes = CollectionsPlume.mapList(Class::getName, method.getParameterTypes());
        OperationSignature operation = OperationSignature.forConstructorName(className, methodName, parameterTypes);
        Identifiers identifiers = new Identifiers("receiver", parameterNames, "result");
        ArrayList<Precondition> preconditions = new ArrayList<Precondition>();
        ArrayList<Postcondition> postconditions = new ArrayList<Postcondition>();
        ArrayList<ThrowsCondition> throwsConditions = new ArrayList<ThrowsCondition>();
        block0: for (Parameter parameter : parameters) {
            AnnotatedType annotatedType = parameter.getAnnotatedType();
            for (Annotation annotation : annotatedType.getAnnotations()) {
                String annotationName = annotation.annotationType().getSimpleName();
                if (!annotationName.equals("NonNull") && !annotationName.equals("Nonnull") && !annotationName.equals("NotNull")) continue;
                String paramName = parameter.getName();
                preconditions.add(new Precondition(paramName + " must be non-null", new Guard(paramName + " must be non-null", paramName + " != null")));
                continue block0;
            }
        }
        AnnotatedType annotatedReturnType = method.getAnnotatedReturnType();
        for (Annotation annotation : annotatedReturnType.getAnnotations()) {
            String annotationName = annotation.annotationType().getSimpleName();
            if (!annotationName.equals("NonNull") && !annotationName.equals("Nonnull") && !annotationName.equals("NotNull")) continue;
            postconditions.add(new Postcondition("returns a non-null result", new Guard("", "true"), new Property("result must be non-null", "result != null")));
            break;
        }
        return new OperationSpecification(operation, identifiers, preconditions, postconditions, throwsConditions);
    }

    public void setExecutableSpecification(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSpecification execSpec) {
        this.execSpec = execSpec;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSpecification getExecutableSpecification() {
        return this.execSpec;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypedOperation)) {
            return false;
        }
        TypedOperation op = (TypedOperation)obj;
        return this.getOperation().equals(op.getOperation()) && this.inputTypes.equals(op.inputTypes) && this.outputType.equals(op.outputType);
    }

    @Override
    @Pure
    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int compareTo(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation other) {
        if (this instanceof TypedTermOperation && other instanceof TypedClassOperation) {
            return -1;
        }
        if (this instanceof TypedClassOperation && other instanceof TypedTermOperation) {
            return 1;
        }
        int result = this.getName().compareTo(other.getName());
        if (result != 0) {
            return result;
        }
        result = this.inputTypes.compareTo(other.inputTypes);
        if (result != 0) {
            return result;
        }
        if (this instanceof TypedClassOperation) {
            TypedClassOperation thisOp = (TypedClassOperation)this;
            TypedClassOperation otherOp = (TypedClassOperation)other;
            result = thisOp.getDeclaringType().compareTo(otherOp.getDeclaringType());
            if (result != 0) {
                return result;
            }
        }
        if ((result = this.outputType.compareTo(other.outputType)) != 0) {
            return result;
        }
        assert (result == 0);
        return result;
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.getOperation(), this.inputTypes, this.outputType);
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        String specString = this.execSpec == null ? "" : " [spec: " + this.execSpec.toString() + "]";
        return StringsPlume.escapeJava(this.getName()) + " : " + this.inputTypes + " -> " + this.outputType + specString;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getName() {
        return this.operation.getName();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getSignatureString() {
        return this.getName() + this.inputTypes;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple getInputTypes() {
        return this.inputTypes;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown randoop.types.Type getOutputType() {
        return this.outputType;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown CallableOperation getOperation() {
        return this.operation;
    }

    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasWildcardTypes();

    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isGeneric() {
        return this.isGeneric(false);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isGeneric(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean ignoreWildcards) {
        return this.inputTypes.isGeneric(ignoreWildcards) || this.outputType.isGeneric(ignoreWildcards);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isStatic() {
        return this.operation.isStatic();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isMessage() {
        return this.operation.isMessage();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isMethodCall() {
        return this.operation.isMethodCall();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isConstantField() {
        return this.operation.isConstantField();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isConstructorCall() {
        return this.operation.isConstructorCall();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isNonreceivingValue() {
        return this.operation.isNonreceivingValue();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object getValue() {
        return this.operation.getValue();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean satisfies(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate) {
        return this.operation.satisfies(reflectionPredicate);
    }

    public abstract void appendCode(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> var1, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown StringBuilder var2);

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutionOutcome execute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] input) {
        assert (input.length == this.inputTypes.size()) : "operation execute expected " + this.inputTypes.size() + ", but got " + input.length;
        return this.getOperation().execute(input);
    }

    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation substitute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution var1);

    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation applyCaptureConversion();

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable> getTypeParameters() {
        return new ArrayList<TypeVariable>(1);
    }

    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toParsableString();

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation forConstructor(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Constructor<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> constructor) {
        ConstructorCall op = new ConstructorCall(constructor);
        ClassOrInterfaceType declaringType = ClassOrInterfaceType.forClass(constructor.getDeclaringClass());
        List<randoop.types.Type> paramTypes = CollectionsPlume.mapList(randoop.types.Type::forType, constructor.getGenericParameterTypes());
        TypeTuple inputTypes = new TypeTuple(paramTypes);
        return new TypedClassOperation((CallableOperation)op, declaringType, inputTypes, declaringType);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation forMethod(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method method) {
        List<randoop.types.Type> methodParamTypes = CollectionsPlume.mapList(randoop.types.Type::forType, method.getGenericParameterTypes());
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass.isAnonymousClass() && declaringClass.getEnclosingClass() != null && declaringClass.getEnclosingClass().isEnum()) {
            return TypedOperation.getAnonEnumOperation(method, methodParamTypes, declaringClass.getEnclosingClass());
        }
        ArrayList<randoop.types.Type> paramTypes = new ArrayList<randoop.types.Type>(methodParamTypes.size() + 1);
        MethodCall op = new MethodCall(method);
        ClassOrInterfaceType declaringType = ClassOrInterfaceType.forClass(method.getDeclaringClass());
        if (!op.isStatic()) {
            paramTypes.add(declaringType);
        }
        paramTypes.addAll(methodParamTypes);
        TypeTuple inputTypes = new TypeTuple(paramTypes);
        randoop.types.Type outputType = randoop.types.Type.forType(method.getGenericReturnType());
        if (outputType.isVariable()) {
            return new TypedClassOperationWithCast((CallableOperation)op, declaringType, inputTypes, outputType);
        }
        return new TypedClassOperation((CallableOperation)op, declaringType, inputTypes, outputType);
    }

    private static @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation getAnonEnumOperation(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method method, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown randoop.types.Type> methodParamTypes, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> enumClass) {
        ClassOrInterfaceType enumType = ClassOrInterfaceType.forClass(enumClass);
        for (Method publicMethod : enumClass.getMethods()) {
            int i;
            Type[] mGenericParamTypes;
            if (!publicMethod.getName().equals(method.getName()) || (mGenericParamTypes = publicMethod.getGenericParameterTypes()).length != method.getGenericParameterTypes().length) continue;
            ArrayList<randoop.types.Type> paramTypes = new ArrayList<randoop.types.Type>(mGenericParamTypes.length + 1);
            MethodCall op = new MethodCall(publicMethod);
            if (!op.isStatic()) {
                paramTypes.add(enumType);
            }
            for (Type t2 : mGenericParamTypes) {
                paramTypes.add(randoop.types.Type.forType(t2));
            }
            TypeTuple inputTypes = new TypeTuple(paramTypes);
            randoop.types.Type outputType = randoop.types.Type.forType(publicMethod.getGenericReturnType());
            ClassOrInterfaceType methodDeclaringType = ClassOrInterfaceType.forClass(publicMethod.getDeclaringClass());
            if (methodDeclaringType.isGeneric()) {
                GenericClassType genDeclaringType = (GenericClassType)methodDeclaringType;
                InstantiatedType superType = enumType.getMatchingSupertype(genDeclaringType);
                assert (superType != null) : "should exist a super type of enum instantiating " + genDeclaringType;
                Substitution substitution = superType.getTypeSubstitution();
                inputTypes = inputTypes.substitute(substitution);
                outputType = outputType.substitute(substitution);
            }
            int d = op.isStatic() ? 0 : 1;
            for (i = 0; i < methodParamTypes.size() && methodParamTypes.get(i).equals(inputTypes.get(i + d)); ++i) {
            }
            if (i != methodParamTypes.size()) continue;
            return new TypedClassOperation((CallableOperation)op, enumType, inputTypes, outputType);
        }
        System.out.println(method.getName() + " is bridge? " + method.isBridge() + " is synthetic? " + method.isSynthetic());
        return null;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation createGetterForField(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Field field, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType declaringType) {
        randoop.types.Type fieldType = randoop.types.Type.forType(field.getGenericType());
        AccessibleField accessibleField = new AccessibleField(field, declaringType);
        ArrayList<randoop.types.Type> inputTypes = new ArrayList<randoop.types.Type>(1);
        if (!accessibleField.isStatic()) {
            inputTypes.add(declaringType);
        }
        return new TypedClassOperation((CallableOperation)new FieldGet(accessibleField), declaringType, new TypeTuple(inputTypes), fieldType);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation createSetterForField(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Field field, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType declaringType) {
        randoop.types.Type fieldType = randoop.types.Type.forType(field.getGenericType());
        AccessibleField accessibleField = new AccessibleField(field, declaringType);
        ArrayList<randoop.types.Type> inputTypes = new ArrayList<randoop.types.Type>(2);
        if (!accessibleField.isStatic()) {
            inputTypes.add(declaringType);
        }
        inputTypes.add(fieldType);
        return new TypedClassOperation((CallableOperation)new FieldSet(accessibleField), declaringType, new TypeTuple(inputTypes), JavaTypes.VOID_TYPE);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation createNullOrZeroInitializationForType(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown randoop.types.Type type) {
        return TypedOperation.createNonreceiverInitialization(NonreceiverTerm.createNullOrZeroTerm(type));
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation createPrimitiveInitialization(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown randoop.types.Type type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object value) {
        randoop.types.Type valueType = randoop.types.Type.forValue(value);
        assert (valueType.isNonreceiverType()) : "must be nonreceiver type, got " + type.getBinaryName();
        return TypedOperation.createNonreceiverInitialization(new NonreceiverTerm(type, value));
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation createNonreceiverInitialization(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown NonreceiverTerm term) {
        return new TypedTermOperation(term, new TypeTuple(), term.getType());
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation createInitializedArrayCreation(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ArrayType arrayType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int size) {
        List<randoop.types.Type> typeList = Collections.nCopies(size, arrayType.getComponentType());
        TypeTuple inputTypes = new TypeTuple(typeList);
        return new TypedTermOperation(new InitializedArrayCreation(arrayType, size), inputTypes, arrayType);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation createArrayCreation(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ArrayType arrayType) {
        List<randoop.types.Type> typeList = Collections.singletonList(JavaTypes.INT_TYPE);
        TypeTuple inputTypes = new TypeTuple(typeList);
        return new TypedTermOperation(new ArrayCreation(arrayType), inputTypes, arrayType);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation createCast(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown randoop.types.Type fromType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown randoop.types.Type toType) {
        List<randoop.types.Type> typeList = Collections.singletonList(fromType);
        TypeTuple inputTypes = new TypeTuple(typeList);
        return new TypedTermOperation(new UncheckedCast(toType), inputTypes, toType);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation createArrayElementAssignment(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ArrayType arrayType) {
        ArrayList<randoop.types.Type> typeList = new ArrayList<randoop.types.Type>(3);
        typeList.add(arrayType);
        typeList.add(JavaTypes.INT_TYPE);
        typeList.add(arrayType.getComponentType());
        TypeTuple inputTypes = new TypeTuple(typeList);
        return new TypedTermOperation(new ArrayElementSet(arrayType.getComponentType()), inputTypes, JavaTypes.VOID_TYPE);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isUncheckedCast() {
        return this.operation.isUncheckedCast();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExpectedOutcomeTable checkPrestate(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] values) {
        if (this.execSpec == null) {
            return new ExpectedOutcomeTable();
        }
        return this.execSpec.checkPrestate(this.addNullReceiverIfStatic(values));
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] addNullReceiverIfStatic(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] values) {
        @Nullable Object[] args = values;
        if (this.isStatic()) {
            args = new Object[values.length + 1];
            args[0] = null;
            System.arraycopy(values, 0, args, 1, values.length);
        }
        return args;
    }

    public static class RankedTypeOperation {
        public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown double ranking;
        public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation operation;

        public RankedTypeOperation(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown double ranking, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation operation) {
            this.ranking = ranking;
            this.operation = operation;
        }
    }
}

