/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import java.util.List;
import java.util.Objects;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.main.RandoopBug;
import randoop.operation.CallableOperation;
import randoop.operation.OperationParseException;
import randoop.operation.TypedOperation;
import randoop.operation.TypedTermOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.StringsPlume;
import randoop.sequence.StringTooLongException;
import randoop.sequence.Value;
import randoop.sequence.Variable;
import randoop.types.JavaTypes;
import randoop.types.NonParameterizedType;
import randoop.types.PrimitiveTypes;
import randoop.types.Type;
import randoop.types.TypeTuple;

public final class NonreceiverTerm
extends CallableOperation {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type type;
    private final @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object value;

    public NonreceiverTerm(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object value) {
        if (type == null || type.isVoid()) {
            throw new RandoopBug("type should not be null or void: " + type);
        }
        if (type.isPrimitive() || type.isBoxedPrimitive()) {
            if (value == null) {
                if (type.isPrimitive()) {
                    throw new RandoopBug(String.format("primitive-like values cannot be null: type=%s, value=%s", type, value));
                }
            } else {
                if (!type.isAssignableFromTypeOf(value)) {
                    throw new RandoopBug("value=" + value + ", value.getClass()=" + value.getClass() + ",type=" + type);
                }
                if (!NonreceiverTerm.isNonreceiverType(value.getClass())) {
                    throw new RandoopBug("value is not a primitive-like value: value = " + value + ", value.getClass() = " + value.getClass() + ", type = " + type);
                }
            }
        } else if (type.isString()) {
            String s2 = (String)value;
            if (value != null && !Value.escapedStringLengthOk(s2)) {
                throw new StringTooLongException(s2);
            }
        } else if (!type.equals(JavaTypes.CLASS_TYPE) && value != null) {
            throw new RandoopBug("value must be null for type " + type + " but was " + value);
        }
        this.type = type;
        this.value = value;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isNonreceiverType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> c) {
        return c.isPrimitive() || c.equals(String.class) || PrimitiveTypes.isBoxedPrimitive(c) || c.equals(Class.class);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NonreceiverTerm)) {
            return false;
        }
        NonreceiverTerm other = (NonreceiverTerm)o;
        return this.type.equals(other.type) && Objects.equals(this.value, other.value);
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return this.type.hashCode() + (this.value == null ? 0 : this.value.hashCode());
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        if (this.type.equals(JavaTypes.CLASS_TYPE)) {
            return ((Class)this.value).getName() + ".class";
        }
        return Objects.toString(this.value);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getName() {
        return this.toString();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutionOutcome execute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] statementInput) {
        assert (statementInput.length == 0);
        return new NormalExecution(this.value, 0L);
    }

    @Override
    public void appendCode(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type declaringType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type outputType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> inputVars, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown StringBuilder b) {
        b.append(Value.toCodeString(this.getValue()));
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object getValue() {
        return this.value;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type getType() {
        return this.type;
    }

    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown NonreceiverTerm createNullOrZeroTerm(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type type) {
        if (type.isBoxedPrimitive()) {
            type = ((NonParameterizedType)type).toPrimitive();
        }
        if (type.isString()) {
            return new NonreceiverTerm(type, "");
        }
        if (type.equals(JavaTypes.CHAR_TYPE)) {
            return new NonreceiverTerm(type, Character.valueOf('a'));
        }
        if (type.equals(JavaTypes.BYTE_TYPE)) {
            return new NonreceiverTerm(type, (byte)0);
        }
        if (type.equals(JavaTypes.SHORT_TYPE)) {
            return new NonreceiverTerm(type, (short)0);
        }
        if (type.equals(JavaTypes.INT_TYPE)) {
            return new NonreceiverTerm(type, 0);
        }
        if (type.equals(JavaTypes.LONG_TYPE)) {
            return new NonreceiverTerm(type, 0L);
        }
        if (type.equals(JavaTypes.FLOAT_TYPE)) {
            return new NonreceiverTerm(type, Float.valueOf(0.0f));
        }
        if (type.equals(JavaTypes.DOUBLE_TYPE)) {
            return new NonreceiverTerm(type, 0.0);
        }
        if (type.equals(JavaTypes.BOOLEAN_TYPE)) {
            return new NonreceiverTerm(type, false);
        }
        return new NonreceiverTerm(type, null);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toParsableString(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type declaringType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type outputType) {
        String valStr;
        if (this.value == null) {
            valStr = "null";
        } else if (this.type.equals(JavaTypes.CHAR_TYPE)) {
            valStr = Integer.toHexString(((Character)this.value).charValue());
        } else if (this.type.equals(JavaTypes.CLASS_TYPE)) {
            valStr = ((Class)this.value).getName() + ".class";
        } else {
            valStr = this.value.toString();
            if (this.type.isString()) {
                valStr = "\"" + StringsPlume.escapeJava(valStr) + "\"";
            }
        }
        return this.type.getBinaryName() + ":" + valStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation parse(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String s2) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationParseException {
        Object value;
        Type type;
        if (s2 == null) {
            throw new IllegalArgumentException("s cannot be null.");
        }
        int colonIdx = s2.indexOf(58);
        if (colonIdx == -1) {
            String msg = "A primitive value declaration description must be of the form <type>:<value> but the description \"" + s2 + "\" does not have this form.";
            throw new OperationParseException(msg);
        }
        String typeString = s2.substring(0, colonIdx);
        String valString = s2.substring(colonIdx + 1);
        if (typeString.matches(".*\\s+.*")) {
            String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description must be of the form <type>:<value> but the <type> description \"" + s2 + "\" contains whitespace characters.";
            throw new OperationParseException(msg);
        }
        if (typeString.equals("String")) {
            typeString = "java.lang.String";
        }
        try {
            type = Type.forName(typeString);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e1) {
            String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description must be of the form <type>:<value> but the <type> given (\"" + typeString + "\") was unrecognized.";
            throw new OperationParseException(msg);
        }
        if (type.equals(JavaTypes.CHAR_TYPE)) {
            try {
                value = Character.valueOf((char)Integer.parseInt(valString, 16));
            }
            catch (NumberFormatException e) {
                String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description must be of the form <type>:<value> but the <value> given (\"" + valString + "\") was not parsable.";
                throw new OperationParseException(msg);
            }
        }
        if (type.equals(JavaTypes.BYTE_TYPE)) {
            try {
                value = Byte.valueOf(valString);
            }
            catch (NumberFormatException e) {
                String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description must be of the form <type>:<value> but the <value> given (\"" + valString + "\") was not parsable.";
                throw new OperationParseException(msg);
            }
        }
        if (type.equals(JavaTypes.SHORT_TYPE)) {
            try {
                value = Short.valueOf(valString);
            }
            catch (NumberFormatException e) {
                String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description must be of the form <type>:<value> but the <value> given (\"" + valString + "\") was not parsable.";
                throw new OperationParseException(msg);
            }
        }
        if (type.equals(JavaTypes.INT_TYPE)) {
            try {
                value = Integer.valueOf(valString);
            }
            catch (NumberFormatException e) {
                String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description must be of the form <type>:<value> but the <value> given (\"" + valString + "\") was not parsable.";
                throw new OperationParseException(msg);
            }
        }
        if (type.equals(JavaTypes.LONG_TYPE)) {
            try {
                value = Long.valueOf(valString);
            }
            catch (NumberFormatException e) {
                String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description must be of the form <type>:<value> but the <value> given (\"" + valString + "\") was not parsable.";
                throw new OperationParseException(msg);
            }
        }
        if (type.equals(JavaTypes.FLOAT_TYPE)) {
            try {
                value = Float.valueOf(valString);
            }
            catch (NumberFormatException e) {
                String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description must be of the form <type>:<value> but the <value> given (\"" + valString + "\") was not parsable.";
                throw new OperationParseException(msg);
            }
        }
        if (type.equals(JavaTypes.DOUBLE_TYPE)) {
            try {
                value = Double.valueOf(valString);
            }
            catch (NumberFormatException e) {
                String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description must be of the form <type>:<value> but the <value> given (\"" + valString + "\") was not parsable.";
                throw new OperationParseException(msg);
            }
        }
        if (type.equals(JavaTypes.BOOLEAN_TYPE)) {
            if (!valString.equals("true") && !valString.equals("false")) {
                String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description must be of the form <type>:<value> but the <value> given (\"" + valString + "\") was not parsable.";
                throw new OperationParseException(msg);
            }
            value = Boolean.valueOf(valString);
        } else if (type.isString()) {
            if (valString.equals("null")) {
                value = null;
            } else {
                if (valString.charAt(0) != '\"' || valString.charAt(valString.length() - 1) != '\"') {
                    String msg = "Error when parsing type/value pair " + s2 + ". A String value declaration description must be of the form java.lang.String:\"thestring\" but the string given was not enclosed in quotation marks.";
                    throw new OperationParseException(msg);
                }
                String valStringContent = valString.substring(1, valString.length() - 1);
                if (!Value.stringLengthOk(valStringContent)) {
                    throw new OperationParseException(String.format("Error when parsing String; length %d is too large", valStringContent.length()));
                }
                value = StringsPlume.unescapeJava(valStringContent);
            }
        } else {
            if (!valString.equals("null")) {
                String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description that is not a primitive value or a string must be of the form <type>:null but the string given (\"" + valString + "\") was not of this form.";
                throw new OperationParseException(msg);
            }
            value = null;
        }
        NonreceiverTerm nonreceiverTerm = new NonreceiverTerm(type, value);
        return new TypedTermOperation(nonreceiverTerm, new TypeTuple(), type);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isNonreceivingValue() {
        return true;
    }
}

