/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import randoop.ExecutionOutcome;
import randoop.operation.CallableOperation;
import randoop.operation.OperationParseException;
import randoop.operation.TypeArguments;
import randoop.operation.TypedClassOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.StringsPlume;
import randoop.reflection.ReflectionPredicate;
import randoop.sequence.Variable;
import randoop.types.Type;
import randoop.types.TypeTuple;
import randoop.util.Log;
import randoop.util.MethodReflectionCode;
import randoop.util.ReflectionExecutor;

public final class MethodCall
extends CallableOperation {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method method;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isStatic;

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method getMethod() {
        return this.method;
    }

    public MethodCall(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method method) {
        if (method == null) {
            throw new IllegalArgumentException("method should not be null.");
        }
        this.method = method;
        this.method.setAccessible(true);
        this.isStatic = Modifier.isStatic(method.getModifiers() & Modifier.methodModifiers());
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return this.method.toString();
    }

    @Override
    public void appendCode(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type declaringType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type outputType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> inputVars, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown StringBuilder sb) {
        int startIndex;
        String methodName = this.getMethod().getName();
        if (this.isStatic()) {
            sb.append(declaringType.getCanonicalName().replace('$', '.'));
        } else {
            String receiverVar = this.isStatic() ? null : inputVars.get(0).getName();
            Type receiverFormalType = inputTypes.get(0);
            if (receiverFormalType.isPrimitive()) {
                sb.append("((").append(receiverFormalType.getFqName()).append(")").append(receiverVar).append(")");
            } else {
                sb.append(receiverVar);
            }
        }
        sb.append(".");
        sb.append(methodName);
        StringJoiner arguments = new StringJoiner(", ", "(", ")");
        for (int i = startIndex = this.isStatic() ? 0 : 1; i < inputVars.size(); ++i) {
            String cast = inputVars.get(i).getType().equals(inputTypes.get(i)) ? "" : "(" + inputTypes.get(i).getFqName() + ") ";
            String param = this.getArgumentString(inputVars.get(i));
            arguments.add(cast + param);
        }
        sb.append(arguments.toString());
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodCall)) {
            return false;
        }
        MethodCall other = (MethodCall)o;
        return this.method.equals(other.method);
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.method);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutionOutcome execute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] input) {
        Log.logPrintf("MethodCall.execute: this = %s%n", this);
        Object receiver = null;
        int paramsLength = input.length;
        int paramsStartIndex = 0;
        if (!this.isStatic()) {
            receiver = input[0];
            --paramsLength;
            paramsStartIndex = 1;
        }
        Object[] params = new Object[paramsLength];
        for (int i = 0; i < params.length; ++i) {
            params[i] = input[i + paramsStartIndex];
            if (!Log.isLoggingOn()) continue;
            Log.logPrintf("  Param %d = %s%n", i, StringsPlume.toStringAndClass(params[i]));
        }
        MethodReflectionCode code = new MethodReflectionCode(this.method, receiver, params);
        return ReflectionExecutor.executeReflectionCode(code);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toParsableString(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type declaringType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type outputType) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.method.getDeclaringClass().getName()).append(".");
        sb.append(this.method.getName()).append("(");
        Class<?>[] params = this.method.getParameterTypes();
        TypeArguments.getTypeArgumentString(sb, params);
        sb.append(")");
        return sb.toString();
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation parse(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String signature) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationParseException {
        Object[] typeArguments;
        Type classType;
        if (signature == null) {
            throw new IllegalArgumentException("signature may not be null");
        }
        int openParPos = signature.indexOf(40);
        int closeParPos = signature.indexOf(41);
        String prefix = signature.substring(0, openParPos);
        int lastDotPos = prefix.lastIndexOf(46);
        assert (lastDotPos >= 0);
        String classname = prefix.substring(0, lastDotPos);
        String opname = prefix.substring(lastDotPos + 1);
        String arguments = signature.substring(openParPos + 1, closeParPos);
        try {
            classType = Type.getTypeforFullyQualifiedName(classname);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            String msg = "Class " + classname + " is not on classpath while parsing \"" + signature + "\"";
            throw new OperationParseException(msg);
        }
        try {
            typeArguments = TypeArguments.getTypeArgumentsForString(arguments);
        }
        catch (OperationParseException e) {
            throw new OperationParseException(e.getMessage() + " while parsing \"" + signature + "\"");
        }
        Method m4 = null;
        try {
            m4 = classType.getRuntimeClass().getDeclaredMethod(opname, (Class<?>[])typeArguments);
        }
        catch (NoSuchMethodException e) {
            try {
                m4 = classType.getRuntimeClass().getMethod(opname, (Class<?>[])typeArguments);
            }
            catch (NoSuchMethodException e2) {
                String msg = "Method " + opname + " with parameters " + Arrays.toString(typeArguments) + " does not exist in " + classType + ": " + e;
                throw new OperationParseException(msg);
            }
        }
        return TypedClassOperation.forMethod(m4);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isMessage() {
        return true;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isMethodCall() {
        return true;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getName() {
        return this.method.getName();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method getReflectionObject() {
        return this.method;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean satisfies(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate) {
        return reflectionPredicate.test(this.method);
    }
}

