/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import java.util.ArrayList;
import java.util.List;
import randoop.ExceptionalExecution;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.field.AccessibleField;
import randoop.field.FieldParser;
import randoop.main.RandoopBug;
import randoop.operation.CallableOperation;
import randoop.operation.OperationParseException;
import randoop.operation.TypedClassOperation;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.reflection.ReflectionPredicate;
import randoop.sequence.SequenceExecutionException;
import randoop.sequence.Variable;
import randoop.types.ClassOrInterfaceType;
import randoop.types.JavaTypes;
import randoop.types.Type;
import randoop.types.TypeTuple;

public class FieldSet
extends CallableOperation {
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibleField field;

    public FieldSet(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibleField field) {
        if (field.isFinal()) {
            throw new IllegalArgumentException("Field may not be final for FieldSet");
        }
        this.field = field;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutionOutcome execute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] statementInput) {
        Object instance = null;
        Object input = statementInput[0];
        if (statementInput.length == 2) {
            instance = statementInput[0];
            input = statementInput[1];
        }
        try {
            this.field.setValue(instance, input);
        }
        catch (RandoopBug | SequenceExecutionException e) {
            throw e;
        }
        catch (Throwable thrown) {
            return new ExceptionalExecution(thrown, 0L);
        }
        return new NormalExecution(null, 0L);
    }

    @Override
    public void appendCode(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type declaringType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type outputType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> inputVars, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown StringBuilder b) {
        b.append(this.field.toCode(declaringType, inputVars));
        b.append(" = ");
        int index = inputVars.size() - 1;
        String rhs = this.getArgumentString(inputVars.get(index));
        b.append(rhs);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toParsableString(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type declaringType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type outputType) {
        return declaringType.getFqName() + ".<set>(" + this.field.getName() + ")";
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation parse(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String descr) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationParseException {
        String errorPrefix = "Error parsing " + descr + " as description for field set statement: ";
        int openParPos = descr.indexOf(40);
        int closeParPos = descr.indexOf(41);
        if (openParPos < 0) {
            String msg = errorPrefix + " expecting parentheses.";
            throw new OperationParseException(msg);
        }
        String prefix = descr.substring(0, openParPos);
        int lastDotPos = prefix.lastIndexOf(46);
        assert (lastDotPos > 0) : "should be a period after the classname: " + descr;
        String classname = prefix.substring(0, lastDotPos);
        String opname = prefix.substring(lastDotPos + 1);
        assert (opname.equals("<set>")) : "expecting <set>, saw " + opname;
        assert (closeParPos > 0) : "no closing parentheses found.";
        String fieldname = descr.substring(openParPos + 1, closeParPos);
        AccessibleField accessibleField = FieldParser.parse(descr, classname, fieldname);
        ClassOrInterfaceType classType = accessibleField.getDeclaringType();
        Type fieldType = Type.forType(accessibleField.getRawField().getGenericType());
        if (accessibleField.isFinal()) {
            throw new OperationParseException("Cannot create setter for final field " + classname + "." + opname);
        }
        ArrayList<Type> setInputTypeList = new ArrayList<Type>(2);
        if (!accessibleField.isStatic()) {
            setInputTypeList.add(classType);
        }
        setInputTypeList.add(fieldType);
        return new TypedClassOperation((CallableOperation)new FieldSet(accessibleField), classType, new TypeTuple(setInputTypeList), JavaTypes.VOID_TYPE);
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return this.field.toString();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getName() {
        return "<set>(" + this.field.getName() + ")";
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldSet)) {
            return false;
        }
        FieldSet s2 = (FieldSet)obj;
        return this.field.equals(s2.field);
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return this.field.hashCode();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isStatic() {
        return this.field.isStatic();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isMessage() {
        return true;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean satisfies(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate) {
        return this.field.satisfies(reflectionPredicate);
    }
}

