/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Objects;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.operation.CallableOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.sequence.Variable;
import randoop.types.ArrayType;
import randoop.types.Type;
import randoop.types.TypeTuple;

public class ArrayCreation
extends CallableOperation {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type elementType;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type componentType;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int dimensions;

    ArrayCreation(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ArrayType arrayType) {
        this.elementType = arrayType.getElementType();
        this.componentType = arrayType.getComponentType();
        this.dimensions = arrayType.getDimensions();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArrayCreation)) {
            return false;
        }
        ArrayCreation arrayCreation = (ArrayCreation)obj;
        return this.elementType.equals(arrayCreation.elementType) && this.dimensions == arrayCreation.dimensions;
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.elementType, this.dimensions);
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        StringBuilder result = new StringBuilder(this.elementType.getBinaryName());
        for (int i = 0; i < this.dimensions; ++i) {
            result.append("[]");
        }
        return result.toString();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutionOutcome execute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] input) {
        assert (input.length == 1) : "requires array dimension as input";
        int length = (Integer)input[0];
        long startTimeMillis = System.currentTimeMillis();
        Object theArray = Array.newInstance(this.componentType.getRuntimeClass(), length);
        long totalTime = System.currentTimeMillis() - startTimeMillis;
        return new NormalExecution(theArray, totalTime);
    }

    @Override
    public void appendCode(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type declaringType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type outputType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> inputVars, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown StringBuilder b) {
        Variable inputVar = inputVars.get(0);
        b.append("new").append(" ").append(this.elementType.getFqName());
        b.append("[ ");
        String param = this.getArgumentString(inputVar);
        b.append(param).append(" ]");
        for (int i = 1; i < this.dimensions; ++i) {
            b.append("[]");
        }
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toParsableString(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type declaringType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type outputType) {
        StringBuilder result = new StringBuilder(this.elementType.getBinaryName() + "[ " + inputTypes.get(0) + " ]");
        for (int i = 1; i < this.dimensions; ++i) {
            result.append("[]");
        }
        return result.toString();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getName() {
        return this.toString();
    }
}

