/*
 * Decompiled with CFR 0.152.
 */
package randoop.instrument;

import coveredclass.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import coveredclass.org.checkerframework.checker.mustcall.qual.MustCall;
import coveredclass.org.checkerframework.checker.mustcall.qual.Owning;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.regex.qual.UnknownRegex;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.checker.signedness.qual.Signed;
import coveredclass.org.checkerframework.common.value.qual.UnknownVal;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.plumelib.options.Option;
import org.plumelib.options.Options;
import org.plumelib.util.CollectionsPlume;
import org.plumelib.util.EntryReader;
import randoop.MethodReplacements;
import randoop.instrument.CallReplacementTransformer;
import randoop.instrument.MethodSignature;
import randoop.instrument.ReplacementFileException;
import randoop.instrument.ReplacementFileReader;

public class ReplaceCallAgent {
    @Option(value="print debug information")
    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean debug = false;
    @Option(value="directory name where debug logs are written")
    public static @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String debug_directory;
    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path debugPath;
    @Option(value="print progress information")
    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean verbose;
    @Option(value="file listing methods whose calls to replace by substitute methods")
    public static @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path replacement_file;
    @Option(value="file listing packages whose classes should not be transformed")
    public static @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path dont_transform;

    public static void premain(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String agentArgs, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Instrumentation instrumentation) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IOException {
        try {
            Map<MethodSignature, MethodSignature> replacementMap;
            Options options;
            Object[] target_args;
            if (agentArgs != null && (target_args = (options = new Options(ReplaceCallAgent.class)).parse(true, Options.tokenize(agentArgs))).length > 0) {
                System.err.printf("Unexpected agent arguments %s%n", Arrays.toString(target_args));
                System.exit(1);
            }
            if (verbose) {
                System.out.format("In premain, agentargs ='%s', Instrumentation = '%s'%n", agentArgs, instrumentation);
            }
            debugPath = Paths.get("", new String[0]).toAbsolutePath().toAbsolutePath();
            if (debug && debug_directory != null && !debug_directory.isEmpty() && !Files.exists(debugPath = debugPath.resolve(debug_directory), new LinkOption[0])) {
                Files.createDirectory(debugPath, new FileAttribute[0]);
            }
            LinkedHashSet<String> excludedPackagePrefixes = new LinkedHashSet<String>();
            String exclusionFileName = "/default-load-exclusions.txt";
            try (InputStream inputStream = ReplaceCallAgent.class.getResourceAsStream(exclusionFileName);){
                if (inputStream == null) {
                    throw new BugInAgentException("Unable to find default package exclusion file.");
                }
                try {
                    excludedPackagePrefixes.addAll(ReplaceCallAgent.loadExclusions(new InputStreamReader(inputStream, StandardCharsets.UTF_8), exclusionFileName));
                }
                catch (IOException e) {
                    throw new BugInAgentException("Unable to read default package exclusion file: " + e.getMessage());
                }
            }
            Path exclusionFilePath = null;
            if (dont_transform != null) {
                String dont_transform_string = dont_transform.toString();
                try (BufferedReader dont_transform_reader = Files.newBufferedReader(dont_transform, StandardCharsets.UTF_8);){
                    excludedPackagePrefixes.addAll(ReplaceCallAgent.loadExclusions(dont_transform_reader, dont_transform_string));
                }
                catch (IOException e) {
                    System.err.format("Error reading package exclusion file %s:%n %s%n", dont_transform, e.getMessage());
                    System.exit(1);
                }
                exclusionFilePath = dont_transform;
            }
            String replacementPath = "/default-replacements.txt";
            try (InputStream inputStream = ReplaceCallAgent.class.getResourceAsStream(replacementPath);){
                if (inputStream == null) {
                    throw new BugInAgentException("Unable to open default replacements file.");
                }
                try {
                    replacementMap = ReplacementFileReader.readReplacements(new InputStreamReader(inputStream, StandardCharsets.UTF_8), replacementPath);
                }
                catch (ReplacementFileException e) {
                    throw new BugInAgentException("Error reading default replacement file. " + e.getMessage());
                }
            }
            Path replacementFilePath = null;
            if (replacement_file != null) {
                try {
                    replacementMap.putAll(ReplacementFileReader.readReplacements(replacement_file));
                }
                catch (Throwable e) {
                    System.err.printf("Error reading replacement file %s:%n  %s%n", replacement_file, e.getMessage());
                    System.exit(1);
                }
                assert (replacement_file != null) : "@AssumeAssertion(nullness): no side effects above";
                replacementFilePath = replacement_file;
            }
            MethodReplacements.setAgentPath(ReplaceCallAgent.getAgentPath());
            MethodReplacements.setAgentArgs(ReplaceCallAgent.createAgentArgs(replacementFilePath, exclusionFilePath));
            if (debug) {
                // empty if block
            }
            List<String> signatureList = CollectionsPlume.mapList(MethodSignature::toString, replacementMap.keySet());
            MethodReplacements.setReplacedMethods(signatureList);
            CallReplacementTransformer transformer = new CallReplacementTransformer(replacementMap, excludedPackagePrefixes);
            transformer.addMapFileShutdownHook();
            instrumentation.addTransformer(transformer);
        }
        catch (BugInAgentException e) {
            System.err.println("Error in replacecall agent: " + e.getMessage());
            System.err.println("For problems with the default replacements file, make sure that the replacecall.jar file is on the bootclasspath.");
            System.err.println("Otherwise, please report at https://github.com/randoop/randoop/issues ,");
            System.err.println("providing the information requested at https://randoop.github.io/randoop/manual/index.html#bug-reporting .");
            System.exit(1);
        }
        catch (Throwable e) {
            System.err.println("Unexpected exception thrown by replacecall agent: " + e.getMessage());
            System.err.println("Please report at https://github.com/randoop/randoop/issues ,");
            System.err.println("providing the information requested at https://randoop.github.io/randoop/manual/index.html#bug-reporting .");
            System.exit(1);
        }
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> loadExclusions(@Owning @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Reader exclusionReader, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String filename) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IOException {
        LinkedHashSet<String> excludedPackagePrefixes = new LinkedHashSet<String>();
        try (EntryReader reader = new EntryReader(exclusionReader, filename, "//.*$", null);){
            for (String line : reader) {
                String trimmed = line.trim();
                if (trimmed.isEmpty()) continue;
                if (trimmed.charAt(trimmed.length() - 1) != '.') {
                    trimmed = trimmed + ".";
                }
                excludedPackagePrefixes.add(trimmed);
            }
        }
        return excludedPackagePrefixes;
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getAgentPath() throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BugInAgentException {
        Class<?> c;
        try {
            c = Class.forName("randoop.instrument.ReplaceCallAgent");
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new BugInAgentException("Error loading ReplaceCallAgent", e);
        }
        if (c.getClassLoader() != null) {
            throw new BugInAgentException("Agent should be included on bootclasspath");
        }
        String resource = "randoop/instrument/ReplaceCallAgent.class";
        URL url = ClassLoader.getSystemResource(resource);
        if (url == null) {
            System.err.format("Cannot find resource %s%n", resource);
            System.exit(1);
        }
        String jarFilePath = ReplaceCallAgent.getJarPathFromURL(url);
        if (debug) {
            System.err.println("AgentPath: " + jarFilePath);
        }
        return jarFilePath;
    }

    protected static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getJarPathFromURL(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown URL url) {
        String jarPath = url.getPath();
        int offset = System.getProperty("os.name").startsWith("Windows") ? 2 : 1;
        return jarPath.substring(jarPath.indexOf(":") + offset, jarPath.indexOf("!"));
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String createAgentArgs(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path replacementFilePath, @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path exclusionFilePath) {
        StringJoiner result = new StringJoiner(",");
        if (replacementFilePath != null) {
            result.add("--replacement-file=" + replacementFilePath.toAbsolutePath());
        }
        if (exclusionFilePath != null) {
            result.add("--dont-transform=" + exclusionFilePath.toAbsolutePath());
        }
        return result.toString();
    }

    static {
        verbose = false;
        replacement_file = null;
        dont_transform = null;
    }

    private static class BugInAgentException
    extends Throwable {
        BugInAgentException(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String message) {
            super(message);
        }

        BugInAgentException(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String message, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Throwable cause) {
            super(message, cause);
        }
    }
}

