/*
 * Decompiled with CFR 0.152.
 */
package randoop.instrument;

import coveredclass.javassist.CannotCompileException;
import coveredclass.javassist.ClassPool;
import coveredclass.javassist.CtClass;
import coveredclass.javassist.CtConstructor;
import coveredclass.javassist.CtField;
import coveredclass.javassist.CtMethod;
import coveredclass.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import coveredclass.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import coveredclass.org.checkerframework.checker.mustcall.qual.MustCall;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.regex.qual.RegexBottom;
import coveredclass.org.checkerframework.checker.regex.qual.UnknownRegex;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.checker.signedness.qual.Signed;
import coveredclass.org.checkerframework.checker.signedness.qual.SignednessBottom;
import coveredclass.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import coveredclass.org.checkerframework.common.value.qual.BottomVal;
import coveredclass.org.checkerframework.common.value.qual.UnknownVal;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import randoop.main.RandoopBug;

public class CoveredClassTransformer
implements ClassFileTransformer {
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassPool pool = ClassPool.getDefault();

    CoveredClassTransformer() {
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown byte @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] transform(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassLoader loader, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String className, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> classBeingRedefined, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ProtectionDomain protectionDomain, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown byte @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] classfileBuffer) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IllegalClassFormatException {
        byte[] bytecode;
        CtClass cc;
        String qualifiedName = className.replace('/', '.');
        if (qualifiedName.startsWith("java.") || qualifiedName.startsWith("javax.") || qualifiedName.startsWith("jdk.") || qualifiedName.startsWith("apple.") || qualifiedName.startsWith("com.apple.") || qualifiedName.startsWith("com.oracle.") || qualifiedName.startsWith("com.sun.") || qualifiedName.startsWith("org.ietf.") || qualifiedName.startsWith("org.jcp.") || qualifiedName.startsWith("org.omg.") || qualifiedName.startsWith("org.w3c") || qualifiedName.startsWith("org.xml.") || qualifiedName.startsWith("sun.")) {
            return null;
        }
        if (qualifiedName.startsWith("org.junit.") || qualifiedName.startsWith("org.hamcrest.") || qualifiedName.startsWith("org.gradle.") || qualifiedName.startsWith("worker.org.gradle.")) {
            return null;
        }
        if (qualifiedName.startsWith("randoop.") || qualifiedName.startsWith("replacecall.") || qualifiedName.startsWith("org.plumelib.")) {
            return null;
        }
        if (qualifiedName.startsWith("coveredclass.")) {
            return null;
        }
        try {
            cc = this.pool.makeClassIfNew(new ByteArrayInputStream(classfileBuffer));
        }
        catch (Exception e) {
            throw new RandoopBug("Unable to instrument file: " + e);
        }
        if (cc.isFrozen() || cc.isInterface()) {
            return null;
        }
        this.modifyClass(cc);
        try {
            bytecode = cc.toBytecode();
        }
        catch (IOException e) {
            throw new RandoopBug("Unable to convert instrumentation to bytecode: " + e);
        }
        catch (CannotCompileException e) {
            throw new RandoopBug("Error in instrumentation code: " + e);
        }
        cc.detach();
        return bytecode;
    }

    private void modifyClass(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown CtClass cc) {
        String flagFieldName = "randoop_classUsedFlag";
        try {
            CtField flagField = new CtField(CtClass.booleanType, flagFieldName, cc);
            flagField.setModifiers(8);
            cc.addField(flagField, "false");
        }
        catch (CannotCompileException e) {
            throw new Error("error adding instrumentation field: " + e);
        }
        String flagFieldAccess = cc.getName() + "#" + flagFieldName;
        String statementToSetFlag = flagFieldAccess + " = true;";
        try {
            for (CtMethod m4 : cc.getDeclaredMethods()) {
                int mods = m4.getModifiers();
                if (Modifier.isNative(mods) || Modifier.isAbstract(mods)) continue;
                m4.insertBefore(statementToSetFlag);
            }
        }
        catch (CannotCompileException e) {
            throw new Error("error instrumenting method: " + e);
        }
        try {
            for (CtConstructor c : cc.getConstructors()) {
                c.insertBefore(statementToSetFlag);
            }
        }
        catch (CannotCompileException e) {
            throw new Error("error instrumenting constructor: " + e);
        }
        try {
            String methodName = "randoop_checkAndReset";
            CtMethod pollMethod = new CtMethod(CtClass.booleanType, methodName, new CtClass[0], cc);
            pollMethod.setBody("{boolean state = " + flagFieldAccess + "; " + flagFieldAccess + " = false;return state;}");
            pollMethod.setModifiers(9);
            cc.addMethod(pollMethod);
        }
        catch (CannotCompileException e) {
            throw new Error("error adding instrumentation method: " + e);
        }
    }
}

