/*
 * Decompiled with CFR 0.152.
 */
package randoop.generation;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import randoop.generation.AbstractGenerator;
import randoop.generation.OperationHistoryLogger;
import randoop.main.GenInputsAbstract;
import randoop.main.RandoopUsageError;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.plumelib.util.FileWriterWithName;
import randoop.util.Util;

public class TestUtils {
    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean debug = false;

    public static void setAllLogs(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AbstractGenerator generator) {
        TestUtils.setRandoopLog();
        TestUtils.setSelectionLog();
        TestUtils.setOperationLog(generator);
    }

    public static void setRandoopLog() {
        String randoopLog = System.getProperty("randoop.log");
        TestUtils.setRandoopLog(randoopLog);
    }

    public static void setRandoopLog(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String filename) {
        if (debug) {
            System.out.println("setRandoopLog(" + filename + ")");
        }
        if (filename == null) {
            return;
        }
        if (filename.isEmpty()) {
            throw new IllegalArgumentException();
        }
        try {
            GenInputsAbstract.log = new FileWriterWithName(filename);
        }
        catch (IOException ioe) {
            throw new RandoopUsageError("Cannot write log file " + Util.filenameAndAbsolute(filename), ioe);
        }
    }

    public static void setSelectionLog() {
        String selectionLog = System.getProperty("randoop.selection.log");
        TestUtils.setSelectionLog(selectionLog);
    }

    public static void setSelectionLog(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String filename) {
        if (debug) {
            System.out.println("setSelectionLog(" + filename + ")");
        }
        if (filename == null) {
            return;
        }
        if (filename.isEmpty()) {
            throw new IllegalArgumentException();
        }
        try {
            FileWriterWithName fw = new FileWriterWithName(filename);
            Throwable throwable = null;
            try {
                TestUtils.setSelectionLog(fw);
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    TestUtils.$closeResource(throwable, fw);
                    throw throwable3;
                }
            }
            TestUtils.$closeResource(throwable, fw);
        }
        catch (IOException e) {
            throw new Error("problem creating selection log " + Util.filenameAndAbsolute(filename), e);
        }
    }

    public static void setSelectionLog(@UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown FileWriterWithName fw) {
        if (debug) {
            System.out.println("setSelectionLog(" + fw + ")");
        }
        GenInputsAbstract.selection_log = fw;
    }

    public static void setOperationLog(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AbstractGenerator generator) {
        TestUtils.setOperationLog(System.getProperty("randoop.operation.history.log"), generator);
    }

    public static void setOperationLog(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String filename, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AbstractGenerator generator) {
        if (debug) {
            System.out.println("setOperationLog(" + filename + ")");
        }
        if (filename == null) {
            return;
        }
        if (filename.isEmpty()) {
            throw new IllegalArgumentException();
        }
        try (PrintWriter pw = new PrintWriter(new File(filename), StandardCharsets.UTF_8.name());){
            TestUtils.setOperationLog(pw, generator);
        }
        catch (IOException e) {
            throw new Error("problem creating operation log " + Util.filenameAndAbsolute(filename), e);
        }
    }

    public static void setOperationLog(@UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown PrintWriter pw, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AbstractGenerator generator) {
        if (debug) {
            System.out.println("setOperationLog(" + pw + ")");
        }
        if (pw != null) {
            OperationHistoryLogger historyLogger = new OperationHistoryLogger(pw);
            generator.setOperationHistoryLogger(historyLogger);
        }
    }
}

