/*
 * Decompiled with CFR 0.152.
 */
package randoop.generation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.plumelib.util.CollectionsPlume;
import randoop.sequence.Sequence;
import randoop.types.JavaTypes;
import randoop.types.Type;

public final class SeedSequences {
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object> primitiveSeeds = Arrays.asList((byte)-1, (byte)0, (byte)1, (byte)10, (byte)100, (short)-1, (short)0, (short)1, (short)10, (short)100, -1, 0, 1, 10, 100, -1L, 0L, 1L, 10L, 100L, Float.valueOf(-1.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(10.0f), Float.valueOf(100.0f), -1.0, 0.0, 1.0, 10.0, 100.0, Character.valueOf('#'), Character.valueOf(' '), Character.valueOf('4'), Character.valueOf('a'), true, false, "", "hi!");

    private SeedSequences() {
        throw new IllegalStateException("no instance");
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> defaultSeeds() {
        ArrayList<Object> seeds = new ArrayList<Object>(primitiveSeeds);
        return SeedSequences.objectsToSeeds(seeds);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> objectsToSeeds(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object> seeds) {
        LinkedHashSet<Sequence> seedSequences = new LinkedHashSet<Sequence>(CollectionsPlume.mapCapacity(seeds));
        for (Object seed : seeds) {
            if (seed == null) {
                seedSequences.add(Sequence.zero(JavaTypes.STRING_TYPE));
                continue;
            }
            seedSequences.add(Sequence.createSequenceForPrimitive(seed));
        }
        return seedSequences;
    }

    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object> getSeeds(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type type) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        for (Object seed : primitiveSeeds) {
            if (!type.isAssignableFromTypeOf(seed)) continue;
            result.add(seed);
        }
        return result;
    }
}

