/*
 * Decompiled with CFR 0.152.
 */
package randoop.generation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import randoop.generation.ComponentManager;
import randoop.main.GenInputsAbstract;
import randoop.main.RandoopBug;
import randoop.operation.CallableOperation;
import randoop.operation.ConstructorCall;
import randoop.operation.MethodCall;
import randoop.operation.NonreceiverTerm;
import randoop.operation.TypedClassOperation;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.plumelib.util.StringsPlume;
import randoop.sequence.Sequence;
import randoop.sequence.TupleSequence;
import randoop.sequence.Variable;
import randoop.types.ArrayType;
import randoop.types.ClassOrInterfaceType;
import randoop.types.GenericClassType;
import randoop.types.InstantiatedType;
import randoop.types.JDKTypes;
import randoop.types.JavaTypes;
import randoop.types.ParameterBound;
import randoop.types.ParameterizedType;
import randoop.types.ReferenceArgument;
import randoop.types.ReferenceBound;
import randoop.types.ReferenceType;
import randoop.types.Type;
import randoop.types.TypeArgument;
import randoop.types.TypeTuple;
import randoop.types.WildcardArgument;
import randoop.util.Randomness;
import randoop.util.SimpleArrayList;
import randoop.util.SimpleList;

class HelperSequenceCreator {
    private HelperSequenceCreator() {
        throw new Error("Do not instantiate");
    }

    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> createArraySequence(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ComponentManager components, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type collectionType) {
        int length;
        SimpleList<Sequence> candidates;
        int MAX_LENGTH = 7;
        if (!collectionType.isArray()) {
            return new SimpleArrayList<Sequence>(0);
        }
        ArrayType arrayType = (ArrayType)collectionType;
        Type componentType = arrayType.getComponentType();
        if (componentType.isArray()) {
            candidates = HelperSequenceCreator.createArraySequence(components, componentType);
        } else {
            InstantiatedType creationType;
            if (componentType.isParameterized() && (creationType = HelperSequenceCreator.getImplementingTypeForCollection((InstantiatedType)componentType)).isRecursiveType()) {
                componentType = ((ReferenceArgument)creationType.getTypeArguments().get(0)).getReferenceType();
            }
            candidates = components.getSequencesForType(componentType);
        }
        if (candidates.isEmpty()) {
            SimpleArrayList<Sequence> seqList = new SimpleArrayList<Sequence>(1);
            if (!GenInputsAbstract.forbid_null && !Randomness.weightedCoinFlip(0.5)) {
                seqList.add(new Sequence().extend(TypedOperation.createNullOrZeroInitializationForType(componentType), new Variable[0]));
            }
            length = seqList.size();
            candidates = seqList;
        } else {
            length = Randomness.nextRandomInt(7);
        }
        TupleSequence elementsSequence = TupleSequence.createElementsSequence(candidates, length, componentType);
        Sequence s2 = HelperSequenceCreator.createAnArray(elementsSequence, componentType, length);
        assert (s2 != null);
        SimpleArrayList<Sequence> l = new SimpleArrayList<Sequence>(1);
        l.add(s2);
        return l;
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType getElementType(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InstantiatedType collectionType) {
        List<TypeArgument> argumentList = collectionType.getTypeArguments();
        assert (argumentList.size() == 1) : String.format("Collection type %s should have one type argument, has %d", collectionType, argumentList.size());
        TypeArgument argumentType = argumentList.get(0);
        assert (argumentType instanceof ReferenceArgument) : "Type argument " + argumentType + " should be a reference type";
        return ((ReferenceArgument)argumentType).getReferenceType();
    }

    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence createCollection(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ComponentManager componentManager, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InstantiatedType collectionType) {
        ReferenceType elementType = HelperSequenceCreator.getElementType(collectionType);
        InstantiatedType implementingType = HelperSequenceCreator.getImplementingTypeForCollection(collectionType);
        SimpleList<Sequence> candidates = componentManager.getSequencesForType(elementType);
        int length = 0;
        if (!candidates.isEmpty()) {
            length = Randomness.nextRandomInt(candidates.size()) + 1;
        }
        assert (!candidates.isEmpty() || length == 0) : "if there are no candidates, length must be zero";
        TupleSequence elementsSequence = TupleSequence.createElementsSequence(candidates, length, elementType);
        Sequence creationSequence = HelperSequenceCreator.createCollectionCreationSequence(implementingType, elementType);
        if (creationSequence == null) {
            return null;
        }
        if (!(elementType.isParameterized() || elementType.isArray() && ((ArrayType)elementType).hasParameterizedElementType())) {
            int totStatements = 0;
            ArrayList<Sequence> inputSequences = new ArrayList<Sequence>(2);
            ArrayList<Integer> variableIndices = new ArrayList<Integer>(2);
            Sequence inputSequence = HelperSequenceCreator.createAnArray(elementsSequence, elementType, length);
            inputSequences.add(inputSequence);
            int inputIndex = totStatements + inputSequence.getLastVariable().index;
            inputSequences.add(creationSequence);
            int creationIndex = (totStatements += inputSequence.size()) + creationSequence.getLastVariable().index;
            variableIndices.add(creationIndex);
            variableIndices.add(inputIndex);
            TypedOperation addOperation = HelperSequenceCreator.getCollectionAddAllOperation(elementType);
            return Sequence.createSequence(addOperation, inputSequences, variableIndices);
        }
        final TypedOperation addOperation = HelperSequenceCreator.getAddOperation(collectionType, elementType);
        SequenceExtender addExtender = new SequenceExtender(){

            @Override
            public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence extend(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence addSequence, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int creationIndex, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int index, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int i) {
                ArrayList<Variable> inputs = new ArrayList<Variable>(2);
                inputs.add(addSequence.getVariable(creationIndex));
                inputs.add(addSequence.getVariable(index));
                return addSequence.extend(addOperation, inputs);
            }
        };
        return HelperSequenceCreator.buildAddSequence(creationSequence, elementsSequence, addExtender);
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence buildAddSequence(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence creationSequence, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TupleSequence elementsSequence, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SequenceExtender addSequenceExtender) {
        ArrayList<Sequence> inputSequences = new ArrayList<Sequence>(2);
        inputSequences.add(elementsSequence.sequence);
        inputSequences.add(creationSequence);
        Sequence addSequence = Sequence.concatenate(inputSequences);
        int creationIndex = addSequence.getLastVariable().index;
        int i = 0;
        for (int index : elementsSequence.getOutputIndices()) {
            addSequence = addSequenceExtender.extend(addSequence, creationIndex, index, i);
            ++i;
        }
        return addSequence;
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence createCollectionCreationSequence(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InstantiatedType implementingType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType elementType) {
        TypedOperation creationOperation;
        Sequence creationSequence = new Sequence();
        ArrayList<Variable> creationInputs = new ArrayList<Variable>(1);
        if (implementingType.isInstantiationOf(JDKTypes.ENUM_SET_TYPE)) {
            NonreceiverTerm classLiteral = new NonreceiverTerm(JavaTypes.CLASS_TYPE, elementType.getRuntimeClass());
            creationSequence = creationSequence.extend(TypedOperation.createNonreceiverInitialization(classLiteral), new Variable[0]);
            creationInputs.add(creationSequence.getLastVariable());
            creationOperation = HelperSequenceCreator.getEnumSetCreation(implementingType);
        } else {
            Constructor<?> constructor = HelperSequenceCreator.getDefaultConstructor(implementingType);
            if (constructor == null) {
                return null;
            }
            ConstructorCall op = new ConstructorCall(constructor);
            creationOperation = new TypedClassOperation((CallableOperation)op, implementingType, new TypeTuple(), implementingType);
        }
        return creationSequence.extend(creationOperation, creationInputs);
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence createAnArray(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TupleSequence elementsSequence, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type elementType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int length) {
        ArrayType arrayType = ArrayType.ofComponentType(elementType);
        if (!(elementType.isParameterized() || elementType.isArray() && ((ArrayType)elementType).hasParameterizedElementType())) {
            TypedOperation creationOperation = TypedOperation.createInitializedArrayCreation(arrayType, length);
            return Sequence.createSequence(creationOperation, elementsSequence);
        }
        Sequence createSequence = HelperSequenceCreator.createGenericArrayCreationSequence(arrayType, length);
        final TypedOperation arrayElementAssignment = TypedOperation.createArrayElementAssignment(arrayType);
        SequenceExtender addExtender = new SequenceExtender(){

            @Override
            public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence extend(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence addSequence, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int creationIndex, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int index, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int i) {
                addSequence = addSequence.extend(TypedOperation.createPrimitiveInitialization(JavaTypes.INT_TYPE, i), new Variable[0]);
                ArrayList<Variable> inputs = new ArrayList<Variable>(3);
                inputs.add(addSequence.getVariable(creationIndex));
                inputs.add(addSequence.getLastVariable());
                inputs.add(addSequence.getVariable(index));
                return addSequence.extend(arrayElementAssignment, inputs);
            }
        };
        return HelperSequenceCreator.buildAddSequence(createSequence, elementsSequence, addExtender);
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence createGenericArrayCreationSequence(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ArrayType arrayType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int length) {
        ArrayType rawArrayType = arrayType.getRawTypeArray();
        Sequence creationSequence = new Sequence();
        List<Variable> input = new ArrayList<Variable>(1);
        TypedOperation lengthTerm = TypedOperation.createNonreceiverInitialization(new NonreceiverTerm(JavaTypes.INT_TYPE, length));
        creationSequence = creationSequence.extend(lengthTerm, Collections.emptyList());
        input.add(creationSequence.getLastVariable());
        TypedOperation creationOperation = TypedOperation.createArrayCreation(rawArrayType);
        creationSequence = creationSequence.extend(creationOperation, input);
        TypedOperation castOperation = TypedOperation.createCast(rawArrayType, arrayType);
        input = Collections.singletonList(creationSequence.getLastVariable());
        creationSequence = creationSequence.extend(castOperation, input);
        return creationSequence;
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Constructor<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> getDefaultConstructor(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType creationType) {
        Constructor<?> constructor;
        try {
            constructor = creationType.getRuntimeClass().getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return constructor;
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InstantiatedType getImplementingTypeForCollection(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InstantiatedType elementType) {
        InstantiatedType creationType = elementType;
        if (elementType.getGenericClassType().isSubtypeOf(JDKTypes.COLLECTION_TYPE) && elementType.getPackage().equals(JDKTypes.COLLECTION_TYPE.getPackage())) {
            GenericClassType implementingType = JDKTypes.getImplementingTypeForCollection(elementType);
            List<TypeArgument> elementTypeArgs = elementType.getTypeArguments();
            ArrayList<ReferenceType> typeArgumentList = new ArrayList<ReferenceType>(elementTypeArgs.size());
            for (TypeArgument argument : elementTypeArgs) {
                if (argument instanceof ReferenceArgument) {
                    typeArgumentList.add(((ReferenceArgument)argument).getReferenceType());
                    continue;
                }
                if (argument instanceof WildcardArgument) {
                    ParameterBound bound = ((WildcardArgument)argument).getTypeBound();
                    if (bound instanceof ReferenceBound) {
                        typeArgumentList.add(((ReferenceBound)bound).getBoundType());
                        continue;
                    }
                    throw new RandoopBug(String.format("can't handle wildcard with bound %s: %s", StringsPlume.toStringAndClass(bound), StringsPlume.toStringAndClass(argument)));
                }
                throw new RandoopBug(String.format("unexpected argument of %s: %s", elementType, StringsPlume.toStringAndClass(argument)));
            }
            creationType = implementingType.instantiate(typeArgumentList);
        }
        return creationType;
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation getEnumSetCreation(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterizedType creationType) {
        Method method;
        Class<?> enumsetClass = JDKTypes.ENUM_SET_TYPE.getRuntimeClass();
        try {
            method = enumsetClass.getMethod("noneOf", JavaTypes.CLASS_TYPE.getRuntimeClass());
        }
        catch (NoSuchMethodException e) {
            throw new RandoopBug("Can't find \"noneOf\" method for EnumSet: ", e);
        }
        MethodCall op = new MethodCall(method);
        List<Type> paramTypes = Collections.singletonList(JavaTypes.CLASS_TYPE);
        return new TypedClassOperation((CallableOperation)op, creationType, new TypeTuple(paramTypes), creationType);
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation getAddOperation(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterizedType collectionType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType elementType) {
        Method addMethod;
        try {
            addMethod = collectionType.getRuntimeClass().getMethod("add", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new RandoopBug("Can't find add() method for " + collectionType, e);
        }
        MethodCall op = new MethodCall(addMethod);
        ArrayList<Type> arguments = new ArrayList<Type>(2);
        arguments.add(collectionType);
        arguments.add(elementType);
        return new TypedClassOperation((CallableOperation)op, collectionType, new TypeTuple(arguments), JavaTypes.BOOLEAN_TYPE);
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation getCollectionAddAllOperation(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType elementType) {
        Method method;
        Class<Collections> collectionsClass = Collections.class;
        try {
            method = collectionsClass.getMethod("addAll", JDKTypes.COLLECTION_TYPE.getRuntimeClass(), new Object[0].getClass());
        }
        catch (NoSuchMethodException e) {
            throw new RandoopBug("Can't find Collections.addAll method", e);
        }
        MethodCall op = new MethodCall(method);
        assert (method.getTypeParameters().length == 1) : "method should have one type parameter";
        ArrayList<Type> paramTypes = new ArrayList<Type>(2);
        InstantiatedType collectionType = JDKTypes.COLLECTION_TYPE.instantiate(elementType);
        paramTypes.add(collectionType);
        paramTypes.add(ArrayType.ofComponentType(elementType));
        return new TypedClassOperation((CallableOperation)op, ClassOrInterfaceType.forClass(collectionsClass), new TypeTuple(paramTypes), JavaTypes.BOOLEAN_TYPE);
    }

    private static interface SequenceExtender {
        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence extend(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence var1, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int var2, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int var3, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int var4);
    }
}

