/*
 * Decompiled with CFR 0.152.
 */
package randoop.generation;

import randoop.generation.GrtFuzzer;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.Unsigned;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.sequence.Sequence;
import randoop.types.Type;
import randoop.util.Randomness;

public final class GrtStringFuzzer
extends GrtFuzzer {
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GrtStringFuzzer INSTANCE = new GrtStringFuzzer();

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GrtStringFuzzer getInstance() {
        return INSTANCE;
    }

    private GrtStringFuzzer() {
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean canFuzz(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type type) {
        return type.getRuntimeClass() == String.class;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence fuzz(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence sequence) {
        if (sequence.size() == 0) {
            throw new IllegalArgumentException("Cannot fuzz an empty Sequence");
        }
        Object lastValue = sequence.getStatement(sequence.size() - 1).getValue();
        String mutated = GrtStringFuzzer.mutate((String)lastValue);
        return Sequence.concatenate(sequence, Sequence.createSequenceForPrimitive(mutated));
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String mutate(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String s2) {
        StringFuzzingOperation strFuzzingOp = StringFuzzingOperation.random();
        int len = s2.length();
        switch (strFuzzingOp) {
            case INSERT: {
                int pos = Randomness.nextRandomInt(len + 1);
                char c = GrtStringFuzzer.randomPrintableChar();
                return s2.substring(0, pos) + c + s2.substring(pos);
            }
            case REMOVE: {
                if (len == 0) {
                    return s2;
                }
                int rpos = Randomness.nextRandomInt(len);
                return s2.substring(0, rpos) + s2.substring(rpos + 1);
            }
            case REPLACE: {
                if (len == 0) {
                    return s2;
                }
                int xpos = Randomness.nextRandomInt(len);
                char xc = GrtStringFuzzer.randomPrintableChar();
                return s2.substring(0, xpos) + xc + s2.substring(xpos + 1);
            }
            case SUBSTRING: {
                if (len <= 1) {
                    return s2;
                }
                int i1 = Randomness.nextRandomInt(len - 1);
                int i2 = Randomness.nextRandomInt(len - i1) + i1 + 1;
                return s2.substring(i1, i2);
            }
        }
        throw new RandoopBug("Unknown string fuzz op: " + (Object)((Object)strFuzzingOp));
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Unsigned @SignatureUnknown char randomPrintableChar() {
        return (char)(32 + Randomness.nextRandomInt(95));
    }

    public static enum StringFuzzingOperation {
        INSERT,
        REMOVE,
        REPLACE,
        SUBSTRING;


        static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown StringFuzzingOperation random() {
            return StringFuzzingOperation.values()[Randomness.nextRandomInt(StringFuzzingOperation.values().length)];
        }
    }
}

