/*
 * Decompiled with CFR 0.152.
 */
package randoop.generation;

import randoop.generation.GrtFuzzer;
import randoop.main.GenInputsAbstract;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.sequence.Sequence;
import randoop.types.PrimitiveTypes;
import randoop.types.Type;
import randoop.util.Randomness;

public final class GrtNumericFuzzer
extends GrtFuzzer {
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GrtNumericFuzzer INSTANCE = new GrtNumericFuzzer();

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GrtNumericFuzzer getInstance() {
        return INSTANCE;
    }

    private GrtNumericFuzzer() {
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean canFuzz(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type type) {
        Class<?> runtimeClass = type.getRuntimeClass();
        return runtimeClass != Void.TYPE && runtimeClass != Boolean.TYPE && runtimeClass != Boolean.class && (runtimeClass.isPrimitive() || PrimitiveTypes.isBoxedPrimitive(runtimeClass));
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence fuzz(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence sequence) {
        Object fuzzValue;
        if (sequence.size() == 0) {
            throw new IllegalArgumentException("Cannot fuzz an empty Sequence");
        }
        Type inputType = sequence.getLastVariable().getType();
        Object lastValue = sequence.getStatement(sequence.size() - 1).getValue();
        if (lastValue instanceof Number) {
            fuzzValue = GrtNumericFuzzer.sampleMutatedValue(inputType, (Number)lastValue);
        } else if (lastValue instanceof Character) {
            fuzzValue = GrtNumericFuzzer.sampleMutatedValue(inputType, (int)((Character)lastValue).charValue());
        } else {
            throw new RandoopBug("Unexpected type " + lastValue.getClass());
        }
        return Sequence.concatenate(sequence, Sequence.createSequenceForPrimitive(fuzzValue));
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object sampleMutatedValue(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Number orig) {
        Class<?> cls = type.getRuntimeClass();
        double fuzzed = orig.doubleValue() + Randomness.nextRandomGaussian(0.0, GenInputsAbstract.grt_fuzzing_stddev);
        if (cls == Byte.TYPE || cls == Byte.class) {
            return (byte)Math.round(fuzzed);
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return (short)Math.round(fuzzed);
        }
        if (cls == Character.TYPE || cls == Character.class) {
            return Character.valueOf((char)Math.round(fuzzed));
        }
        if (cls == Integer.TYPE || cls == Integer.class) {
            return (int)Math.round(fuzzed);
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return Math.round(fuzzed);
        }
        if (cls == Float.TYPE || cls == Float.class) {
            return Float.valueOf((float)fuzzed);
        }
        if (cls == Double.TYPE || cls == Double.class) {
            return fuzzed;
        }
        throw new RandoopBug("Unexpected numeric type " + type);
    }
}

