/*
 * Decompiled with CFR 0.152.
 */
package randoop.generation;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import randoop.main.RandoopBug;
import randoop.operation.TypedClassOperation;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.reflection.TypeInstantiator;
import randoop.sequence.ClassLiterals;
import randoop.sequence.PackageLiterals;
import randoop.sequence.Sequence;
import randoop.sequence.SequenceCollection;
import randoop.types.ClassOrInterfaceType;
import randoop.types.JavaTypes;
import randoop.types.PrimitiveType;
import randoop.types.Type;
import randoop.util.ListOfLists;
import randoop.util.Log;
import randoop.util.SimpleList;

public class ComponentManager {
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SequenceCollection gralComponents;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> gralSeeds;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassLiterals classLiterals = null;
    private @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown PackageLiterals packageLiterals = null;

    public ComponentManager() {
        this.gralComponents = new SequenceCollection();
        this.gralSeeds = Collections.unmodifiableSet(Collections.emptySet());
    }

    public ComponentManager(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> generalSeeds) {
        LinkedHashSet<Sequence> seedSet = new LinkedHashSet<Sequence>(generalSeeds.size());
        seedSet.addAll(generalSeeds);
        this.gralSeeds = Collections.unmodifiableSet(seedSet);
        this.gralComponents = new SequenceCollection(seedSet);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int numGeneratedSequences() {
        return this.gralComponents.size();
    }

    public void addClassLevelLiteral(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence seq) {
        if (this.classLiterals == null) {
            this.classLiterals = new ClassLiterals();
        }
        this.classLiterals.addSequence(type, seq);
    }

    public void addPackageLevelLiteral(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Package pkg, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence seq) {
        if (this.packageLiterals == null) {
            this.packageLiterals = new PackageLiterals();
        }
        this.packageLiterals.addSequence(pkg, seq);
    }

    public void addGeneratedSequence(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence sequence) {
        this.gralComponents.add(sequence);
    }

    void clearGeneratedSequences() {
        this.gralComponents = new SequenceCollection(this.gralSeeds);
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> getAllGeneratedSequences() {
        return this.gralComponents.getAllSequences();
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> getSequencesForType(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type cls) {
        return this.gralComponents.getSequencesForType(cls, false, false);
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> getSequencesForType(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation operation, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int i, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean onlyReceivers) {
        Type neededType = operation.getInputTypes().get(i);
        if (onlyReceivers && neededType.isNonreceiverType()) {
            throw new RandoopBug(String.format("getSequencesForType(%s, %s, %s) neededType=%s", operation, i, onlyReceivers, neededType));
        }
        SimpleList<Sequence> result = this.gralComponents.getSequencesForType(neededType, false, onlyReceivers);
        ListOfLists literals = null;
        if (operation instanceof TypedClassOperation && !onlyReceivers) {
            ListOfLists sl;
            Package pkg;
            ListOfLists sl2;
            ClassOrInterfaceType declaringCls = ((TypedClassOperation)operation).getDeclaringType();
            assert (declaringCls != null);
            if (this.classLiterals != null && !(sl2 = this.classLiterals.getSequences(declaringCls, neededType)).isEmpty()) {
                literals = sl2;
            }
            if (this.packageLiterals != null && (pkg = declaringCls.getPackage()) != null && !(sl = this.packageLiterals.getSequences(pkg, neededType)).isEmpty()) {
                ListOfLists listOfLists = literals = literals == null ? sl : new ListOfLists(literals, sl);
            }
        }
        if (literals != null) {
            if (result == null) {
                result = literals;
            } else if (literals != null) {
                result = new ListOfLists<Sequence>(result, literals);
            }
        }
        return result;
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> getAllPrimitiveSequences() {
        LinkedHashSet<Sequence> result = new LinkedHashSet<Sequence>();
        if (this.classLiterals != null) {
            result.addAll(this.classLiterals.getAllSequences());
        }
        if (this.packageLiterals != null) {
            result.addAll(this.packageLiterals.getAllSequences());
        }
        for (PrimitiveType type : JavaTypes.getPrimitiveTypes()) {
            result.addAll(this.gralComponents.getSequencesForType(type, true, false).toJDKList());
        }
        result.addAll(this.gralComponents.getSequencesForType(JavaTypes.STRING_TYPE, true, false).toJDKList());
        return result;
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeInstantiator getTypeInstantiator() {
        return this.gralComponents.getTypeInstantiator();
    }

    public void log() {
        if (!Log.isLoggingOn()) {
            return;
        }
        this.gralComponents.log();
    }
}

