/*
 * Decompiled with CFR 0.152.
 */
package randoop.field;

import java.lang.reflect.Field;
import randoop.field.AccessibleField;
import randoop.operation.OperationParseException;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.ClassGetName;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.types.ClassOrInterfaceType;
import randoop.types.Type;

public class FieldParser {
    private FieldParser() {
        throw new Error("Do not instantiate");
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibleField parse(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String descr, @ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String classname, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String fieldname) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationParseException {
        ClassOrInterfaceType classType;
        String errorPrefix = "Error when parsing field " + descr + ".";
        try {
            classType = (ClassOrInterfaceType)Type.forName(classname);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            String msg = errorPrefix + " Class for field " + descr + " not found: " + e.getMessage();
            throw new OperationParseException(msg);
        }
        String whitespacePattern = ".*\\s+.*";
        if (fieldname.matches(whitespacePattern)) {
            String msg = errorPrefix + " The field name " + fieldname + " has unexpected whitespace characters.";
            throw new OperationParseException(msg);
        }
        Field field = FieldParser.fieldForName(classType.getRuntimeClass(), fieldname);
        if (field == null) {
            String msg = errorPrefix + " The field name \"" + fieldname + "\" is not a field of the class \"" + classname + "\".";
            throw new OperationParseException(msg);
        }
        return new AccessibleField(field, classType);
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Field fieldForName(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String fieldName) {
        for (Field f : type.getDeclaredFields()) {
            if (!fieldName.equals(f.getName())) continue;
            return f;
        }
        return null;
    }
}

