/*
 * Decompiled with CFR 0.152.
 */
package randoop.execution;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import randoop.execution.RunCommand;
import randoop.main.GenInputsAbstract;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;

public class TestEnvironment {
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long timeoutMillis = 1200000L;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String testClasspath;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown LinkedHashMap<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> agentMap = new LinkedHashMap();
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path replaceCallAgentPath;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String replaceCallAgentArgs;

    public TestEnvironment(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String testClasspath) {
        this.testClasspath = testClasspath;
    }

    public void addAgent(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path agentPath, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String agentArgumentString) {
        this.agentMap.put(agentPath, agentArgumentString);
    }

    public void setReplaceCallAgent(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path agentPath, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String agentArgs) {
        this.replaceCallAgentPath = agentPath;
        this.replaceCallAgentArgs = agentArgs;
    }

    public void setTimeoutMillis(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RunCommand.Status runTest(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String testClassName, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path workingDirectory) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RunCommand.CommandException {
        List<String> command = this.commandPrefix();
        command.add(testClassName);
        return RunCommand.run(command, workingDirectory, this.timeoutMillis);
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> commandPrefix() {
        ArrayList<String> command = new ArrayList<String>(this.agentMap.size() + 9);
        command.add("java");
        command.add("-ea");
        command.add("-Xmx" + GenInputsAbstract.jvm_max_memory);
        command.add("-XX:+HeapDumpOnOutOfMemoryError");
        if (this.replaceCallAgentPath != null) {
            command.add("-Xbootclasspath/a:" + this.replaceCallAgentPath);
            command.add(this.getJavaagentOption(this.replaceCallAgentPath, this.replaceCallAgentArgs));
        }
        for (Map.Entry<Path, String> entry : this.agentMap.entrySet()) {
            String args = entry.getValue();
            command.add(this.getJavaagentOption(entry.getKey(), args));
        }
        command.add("-classpath");
        command.add("." + File.pathSeparator + this.testClasspath);
        command.add("org.junit.runner.JUnitCore");
        return command;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getJavaagentOption(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path agentPath, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String args) {
        String agent = "-javaagent:" + agentPath;
        if (args != null && !args.isEmpty()) {
            agent = agent + "=" + args;
        }
        return agent;
    }
}

