/*
 * Decompiled with CFR 0.152.
 */
package randoop.contract;

import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.Objects;
import randoop.contract.ObjectContract;
import randoop.main.RandoopBug;
import randoop.operation.CallableOperation;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.StringsPlume;
import randoop.sequence.Value;
import randoop.types.JavaTypes;
import randoop.types.Type;
import randoop.types.TypeTuple;

public final class ObserverEqValue
extends ObjectContract {
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation observer;
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object value;
    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes = new TypeTuple(Arrays.asList(JavaTypes.OBJECT_TYPE));

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObserverEqValue)) {
            return false;
        }
        ObserverEqValue other = (ObserverEqValue)o;
        return this.observer.equals(other.observer) && Objects.equals(this.value, other.value);
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.observer, this.value);
    }

    public ObserverEqValue(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation observer, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object value) {
        assert (observer.isMethodCall() || observer.isConstructorCall()) : "Observer must be MethodCall or ConstructorCall, got " + observer;
        this.observer = observer;
        this.value = value;
        if (!ObserverEqValue.isLiteralValue(value)) {
            throw new RandoopBug(String.format("Cannot represent %s as a literal; observer = %s", StringsPlume.toStringAndClass(value), observer));
        }
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isLiteralValue(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object value) {
        if (value == null) {
            return true;
        }
        Class<?> cls = value.getClass();
        if (cls == Class.class || cls == String.class || cls.isEnum()) {
            return true;
        }
        Type type = Type.forClass(cls);
        return type.isBoxedPrimitive();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCodeString() {
        String call;
        StringBuilder b = new StringBuilder();
        CallableOperation operation = this.observer.getOperation();
        String methodname = operation.getName();
        if (operation.isStatic()) {
            Executable m4 = (Executable)operation.getReflectionObject();
            String theClass = m4.getDeclaringClass().getName();
            call = String.format("%s.%s(x0)", theClass, methodname);
        } else {
            call = String.format("x0.%s()", methodname);
        }
        if (this.value == null) {
            b.append(String.format("org.junit.Assert.assertNull(\"%s == null\", %s);", call, call));
        } else if (this.observer.getOutputType().runtimeClassIs(Boolean.TYPE)) {
            assert (this.value.equals(true) || this.value.equals(false));
            if (this.value.equals(true)) {
                b.append(String.format("org.junit.Assert.assertTrue(%s);", call));
            } else {
                b.append(String.format("org.junit.Assert.assertFalse(%s);", call));
            }
        } else {
            b.append(String.format("org.junit.Assert.assertEquals(%s, %s);", call, Value.toCodeString(this.value)));
        }
        return b.toString();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean evaluate(Object ... objects) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Throwable {
        assert (objects.length == 0);
        throw new RuntimeException("not implemented.");
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int getArity() {
        return 1;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple getInputTypes() {
        return inputTypes;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCommentString() {
        return this.toCodeString();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String get_observer_str() {
        return this.observer.toString();
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return String.format("<ObserverEqValue %s, value = '%s'", this.observer, StringsPlume.toStringAndClass(this.value));
    }
}

