/*
 * Decompiled with CFR 0.152.
 */
package randoop.contract;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.StringJoiner;
import org.junit.Assert;
import randoop.contract.ObjectContract;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.StringsPlume;
import randoop.reflection.AccessibilityPredicate;
import randoop.sequence.Value;
import randoop.types.JavaTypes;
import randoop.types.PrimitiveTypes;
import randoop.types.TypeTuple;

public final class ObserverEqArray
extends ObjectContract {
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object value;
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown double DOUBLE_DELTA = 1.0E-15;
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown float FLOAT_DELTA = 1.0E-15f;
    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes = new TypeTuple(Arrays.asList(JavaTypes.OBJECT_TYPE));

    public ObserverEqArray(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object value, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate isAccessible) {
        this.value = value;
        if (!ObserverEqArray.isLiteralType(value, isAccessible)) {
            throw new RandoopBug(String.format("Cannot represent %s as a literal", StringsPlume.toStringAndClass(value.getClass().getComponentType())));
        }
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isLiteralType(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object value, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate isAccessible) {
        Class<?> cls = value.getClass().getComponentType();
        if (cls == String.class || cls == Class.class) {
            return true;
        }
        if (PrimitiveTypes.isBoxedPrimitive(cls) || cls.isPrimitive()) {
            return true;
        }
        if (!isAccessible.isAccessible(cls)) {
            return false;
        }
        return cls.isEnum() || Arrays.stream((Object[])value).allMatch(element -> element == null);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObserverEqArray)) {
            return false;
        }
        ObserverEqArray other = (ObserverEqArray)o;
        if (!this.value.getClass().equals(other.value.getClass())) {
            return false;
        }
        if (this.value instanceof byte[]) {
            return Arrays.equals((byte[])this.value, (byte[])other.value);
        }
        if (this.value instanceof short[]) {
            return Arrays.equals((short[])this.value, (short[])other.value);
        }
        if (this.value instanceof int[]) {
            return Arrays.equals((int[])this.value, (int[])other.value);
        }
        if (this.value instanceof long[]) {
            return Arrays.equals((long[])this.value, (long[])other.value);
        }
        if (this.value instanceof float[]) {
            return Arrays.equals((float[])this.value, (float[])other.value);
        }
        if (this.value instanceof double[]) {
            return Arrays.equals((double[])this.value, (double[])other.value);
        }
        if (this.value instanceof char[]) {
            return Arrays.equals((char[])this.value, (char[])other.value);
        }
        if (this.value instanceof boolean[]) {
            return Arrays.equals((boolean[])this.value, (boolean[])other.value);
        }
        return Arrays.equals((Object[])this.value, (Object[])other.value);
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        if (this.value instanceof byte[]) {
            return Arrays.hashCode((byte[])this.value);
        }
        if (this.value instanceof short[]) {
            return Arrays.hashCode((short[])this.value);
        }
        if (this.value instanceof int[]) {
            return Arrays.hashCode((int[])this.value);
        }
        if (this.value instanceof long[]) {
            return Arrays.hashCode((long[])this.value);
        }
        if (this.value instanceof float[]) {
            return Arrays.hashCode((float[])this.value);
        }
        if (this.value instanceof double[]) {
            return Arrays.hashCode((double[])this.value);
        }
        if (this.value instanceof char[]) {
            return Arrays.hashCode((char[])this.value);
        }
        if (this.value instanceof boolean[]) {
            return Arrays.hashCode((boolean[])this.value);
        }
        return Arrays.hashCode((Object[])this.value);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCodeString() {
        if (this.value.getClass().getComponentType() == Double.TYPE) {
            return String.format("org.junit.Assert.assertArrayEquals(x0, %s, %s);", this.newArrayExpression(), 1.0E-15);
        }
        if (this.value.getClass().getComponentType() == Float.TYPE) {
            return String.format("org.junit.Assert.assertArrayEquals(x0, %s, (float)%s);", this.newArrayExpression(), Float.valueOf(1.0E-15f));
        }
        if (this.value.getClass().getComponentType() == Boolean.TYPE) {
            return String.format("assertBooleanArrayEquals(x0, %s);", this.newArrayExpression());
        }
        return String.format("org.junit.Assert.assertArrayEquals(x0, %s);", this.newArrayExpression());
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String newArrayExpression() {
        return "new " + this.value.getClass().getCanonicalName() + this.arrayComponentsToString();
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String arrayComponentsToString() {
        StringJoiner sj = new StringJoiner(", ", "{", "}");
        int length = Array.getLength(this.value);
        for (int i = 0; i < length; ++i) {
            sj.add(Value.toCodeString(Array.get(this.value, i)));
        }
        return sj.toString();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean evaluate(Object ... objects) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Throwable {
        assert (objects.length == 1);
        try {
            if (!this.value.getClass().equals(objects[0].getClass())) {
                return false;
            }
            if (this.value instanceof double[]) {
                Assert.assertArrayEquals((double[])this.value, (double[])objects[0], 1.0E-15);
            } else if (this.value instanceof float[]) {
                Assert.assertArrayEquals((float[])this.value, (float[])objects[0], 1.0E-15f);
            } else if (this.value instanceof byte[]) {
                Assert.assertArrayEquals((byte[])this.value, (byte[])objects[0]);
            } else if (this.value instanceof short[]) {
                Assert.assertArrayEquals((short[])this.value, (short[])objects[0]);
            } else if (this.value instanceof int[]) {
                Assert.assertArrayEquals((int[])this.value, (int[])objects[0]);
            } else if (this.value instanceof long[]) {
                Assert.assertArrayEquals((long[])this.value, (long[])objects[0]);
            } else if (this.value instanceof boolean[]) {
                Assert.assertArrayEquals((boolean[])this.value, (boolean[])objects[0]);
            } else if (this.value instanceof char[]) {
                Assert.assertArrayEquals((char[])this.value, (char[])objects[0]);
            } else {
                Assert.assertArrayEquals((Object[])this.value, (Object[])objects[0]);
            }
        }
        catch (AssertionError e) {
            return false;
        }
        return true;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int getArity() {
        return 1;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple getInputTypes() {
        return inputTypes;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCommentString() {
        return this.toCodeString();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String get_observer_str() {
        return "ObserverEqArray";
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return "ObserverEqArray(" + this.arrayComponentsToString() + ")";
    }
}

