/*
 * Decompiled with CFR 0.152.
 */
package randoop.contract;

import java.util.concurrent.TimeoutException;
import randoop.ExceptionalExecution;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.NotExecuted;
import randoop.contract.ObjectContractUtils;
import randoop.main.ExceptionBehaviorClassifier;
import randoop.main.GenInputsAbstract;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.sequence.ExecutableSequence;
import randoop.sequence.Variable;
import randoop.test.Check;
import randoop.test.InvalidExceptionCheck;
import randoop.test.ObjectCheck;
import randoop.types.TypeTuple;
import randoop.util.Log;

public abstract class ObjectContract {
    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int getArity();

    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple getInputTypes();

    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean evaluate(Object ... var1) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Throwable;

    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCommentString();

    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCodeString();

    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String get_observer_str();

    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Check checkContract(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSequence eseq, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] values) {
        ExecutionOutcome outcome = ObjectContractUtils.execute(this, values);
        if (Log.isLoggingOn()) {
            // empty if block
        }
        if (outcome instanceof NormalExecution) {
            boolean result = (Boolean)((NormalExecution)outcome).getRuntimeValue();
            if (result) {
                return null;
            }
            return this.failedContract(eseq, values);
        }
        if (outcome instanceof ExceptionalExecution) {
            Throwable e = ((ExceptionalExecution)outcome).getException();
            Log.logPrintf("checkContract(): Contract %s [%s] threw exception of class %s with message %s%n", this.toCodeString(), this.getClass(), e.getClass(), e.getMessage());
            if (e instanceof RandoopBug) {
                throw (RandoopBug)e;
            }
            if (e instanceof TimeoutException) {
                return new InvalidExceptionCheck(e, eseq.size() - 1, e.getClass().getName());
            }
            GenInputsAbstract.BehaviorType eseqBehavior = ExceptionBehaviorClassifier.classify(e, eseq);
            Log.logPrintf("  ExceptionBehaviorClassifier.classify(e, eseq) => %s%n", new Object[]{eseqBehavior});
            if (eseqBehavior == GenInputsAbstract.BehaviorType.EXPECTED) {
                eseqBehavior = GenInputsAbstract.BehaviorType.INVALID;
            }
            switch (eseqBehavior) {
                case ERROR: {
                    return this.failedContract(eseq, values);
                }
                case EXPECTED: {
                    throw new Error("unreachable (for now)");
                }
                case INVALID: {
                    return new InvalidExceptionCheck(e, eseq.size() - 1, e.getClass().getName());
                }
            }
            throw new Error("unreachable");
        }
        assert (outcome instanceof NotExecuted);
        throw new RandoopBug("Contract " + this + " failed to execute during evaluation");
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ObjectCheck failedContract(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSequence eseq, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] values) {
        Variable[] varArray = new Variable[values.length];
        for (int i = 0; i < varArray.length; ++i) {
            varArray[i] = eseq.getVariable(values[i]);
        }
        return new ObjectCheck(this, varArray);
    }

    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toStringHandleExceptions(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object o) {
        try {
            return o.toString();
        }
        catch (Throwable t2) {
            return "of " + o.getClass() + " with identityHashCode=@" + System.identityHashCode(o);
        }
    }
}

