/*
 * Decompiled with CFR 0.152.
 */
package randoop.condition.specification;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import randoop.com.google.gson.annotations.SerializedName;
import randoop.condition.specification.Identifiers;
import randoop.condition.specification.OperationSignature;
import randoop.condition.specification.Postcondition;
import randoop.condition.specification.Precondition;
import randoop.condition.specification.ThrowsCondition;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public class OperationSpecification {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSignature operation;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Identifiers identifiers;
    @SerializedName(value="pre")
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Precondition> preSpecifications;
    @SerializedName(value="post")
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Postcondition> postSpecifications;
    @SerializedName(value="throws")
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ThrowsCondition> throwsSpecifications;

    private OperationSpecification() {
        this.operation = null;
        this.identifiers = new Identifiers();
        this.preSpecifications = new ArrayList<Precondition>();
        this.postSpecifications = new ArrayList<Postcondition>();
        this.throwsSpecifications = new ArrayList<ThrowsCondition>();
    }

    public OperationSpecification(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSignature operation, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Identifiers identifiers) {
        this(operation, identifiers, new ArrayList<Precondition>(), new ArrayList<Postcondition>(), new ArrayList<ThrowsCondition>());
    }

    public OperationSpecification(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSignature operation, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Identifiers identifiers, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Precondition> preSpecifications, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Postcondition> postSpecifications, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ThrowsCondition> throwsSpecifications) {
        this.operation = operation;
        this.identifiers = identifiers;
        this.preSpecifications = preSpecifications;
        this.postSpecifications = postSpecifications;
        this.throwsSpecifications = throwsSpecifications;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSignature getOperation() {
        return this.operation;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Identifiers getIdentifiers() {
        return this.identifiers;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Precondition> getPreconditions() {
        return this.preSpecifications;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Postcondition> getPostconditions() {
        return this.postSpecifications;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ThrowsCondition> getThrowsConditions() {
        return this.throwsSpecifications;
    }

    public void addParamSpecifications(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Precondition> specifications) {
        this.preSpecifications.addAll(specifications);
    }

    public void addReturnSpecifications(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Postcondition> specifications) {
        this.postSpecifications.addAll(specifications);
    }

    public void addThrowsConditions(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ThrowsCondition> specifications) {
        this.throwsSpecifications.addAll(specifications);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isEmpty() {
        return this.preSpecifications.isEmpty() && this.postSpecifications.isEmpty() && this.throwsSpecifications.isEmpty();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OperationSpecification)) {
            return false;
        }
        OperationSpecification other = (OperationSpecification)object;
        return this.operation.equals(other.operation) && this.identifiers.equals(other.identifiers) && this.preSpecifications.equals(other.preSpecifications) && this.postSpecifications.equals(other.postSpecifications) && this.throwsSpecifications.equals(other.throwsSpecifications);
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.operation, this.identifiers, this.preSpecifications, this.postSpecifications, this.throwsSpecifications);
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        String result = "{ \"operation\": " + this.operation.toString() + ", \"identifiers\": " + this.identifiers + ", \"preSpecifications\": " + this.preSpecifications + " }, \"postSpecifications\": " + this.postSpecifications + ", \"throwsSpecifications\": " + this.throwsSpecifications;
        return result;
    }
}

