/*
 * Decompiled with CFR 0.152.
 */
package randoop.condition.specification;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.ClassGetName;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.CollectionsPlume;

public class OperationSignature {
    private final @ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String classname;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String name;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String> parameterTypes;

    private OperationSignature() {
        this.classname = "";
        this.name = "";
        this.parameterTypes = new ArrayList<String>(0);
    }

    private OperationSignature(@ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String classname, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String name, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String> parameterTypes) {
        this.classname = classname;
        this.name = name;
        this.parameterTypes = parameterTypes;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSignature forConstructorName(@ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String classname, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String simpleName, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String> parameterTypes) {
        return new OperationSignature(classname, simpleName, parameterTypes);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSignature forMethodName(@ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String classname, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String name, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String> parameterTypes) {
        return new OperationSignature(classname, name, parameterTypes);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSignature of(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method method) {
        return new OperationSignature(method.getDeclaringClass().getName(), method.getName(), OperationSignature.getTypeNames(method.getParameterTypes()));
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSignature of(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Constructor<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> constructor) {
        return new OperationSignature(constructor.getDeclaringClass().getName(), constructor.getName(), OperationSignature.getTypeNames(constructor.getParameterTypes()));
    }

    public static @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSignature of(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibleObject op) {
        if (op instanceof Field) {
            return null;
        }
        if (op instanceof Method) {
            return OperationSignature.of((Method)op);
        }
        if (op instanceof Constructor) {
            return OperationSignature.of((Constructor)op);
        }
        throw new Error("how did this happen?");
    }

    public @ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String getClassname() {
        return this.classname;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getName() {
        return this.name;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String> getParameterTypeNames() {
        return this.parameterTypes;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isConstructor() {
        int dotPos;
        if (this.name.equals(this.classname)) {
            return true;
        }
        if (this.name.equals("<init>")) {
            return true;
        }
        String classnameSimple = this.classname;
        int dollarPos = classnameSimple.lastIndexOf(36);
        if (dollarPos != -1) {
            classnameSimple = classnameSimple.substring(dollarPos + 1);
        }
        if ((dotPos = classnameSimple.lastIndexOf(46)) != -1) {
            classnameSimple = classnameSimple.substring(dotPos + 1);
        }
        return this.name.equals(classnameSimple);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isValid() {
        return this.classname != null && !this.classname.isEmpty() && this.name != null && !this.name.isEmpty() && this.parameterTypes != null;
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@ClassGetName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String> getTypeNames(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] classes) {
        return CollectionsPlume.mapList(Class::getName, classes);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OperationSignature)) {
            return false;
        }
        OperationSignature other = (OperationSignature)object;
        return this.classname.equals(other.classname) && this.name.equals(other.name) && this.parameterTypes.equals(other.parameterTypes);
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.classname, this.name, this.parameterTypes);
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return String.format("{%n \"classname\": \"%s\",%n \"name\": \"%s\",%n \"parameterTypes\": \"%s\"%n}", this.classname, this.name, this.parameterTypes);
    }
}

