/*
 * Decompiled with CFR 0.152.
 */
package randoop.condition;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import randoop.compile.SequenceCompiler;
import randoop.condition.ExecutableBooleanExpression;
import randoop.condition.ExecutableSpecification;
import randoop.condition.GuardPropertyPair;
import randoop.condition.GuardThrowsPair;
import randoop.condition.RandoopSpecificationError;
import randoop.condition.ThrowsClause;
import randoop.condition.specification.Guard;
import randoop.condition.specification.Identifiers;
import randoop.condition.specification.OperationSpecification;
import randoop.condition.specification.Postcondition;
import randoop.condition.specification.Precondition;
import randoop.condition.specification.Property;
import randoop.condition.specification.ThrowsCondition;
import randoop.main.GenInputsAbstract;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.DotSeparatedIdentifiers;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.plumelib.util.CollectionsPlume;
import randoop.reflection.RawSignature;
import randoop.types.ClassOrInterfaceType;
import randoop.util.Log;
import randoop.util.Util;

public class SpecificationTranslator {
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String DUMMY_VARIABLE_BASE_NAME = "x";
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RawSignature prestateExpressionSignature;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String prestateExpressionDeclaration;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RawSignature poststateExpressionSignature;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String poststateExpressionDeclarations;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> replacementMap;
    private final @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SequenceCompiler compiler;

    private SpecificationTranslator(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RawSignature prestateExpressionSignature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String prestateExpressionDeclaration, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RawSignature poststateExpressionSignature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String poststateExpressionDeclaration, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> replacementMap, @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SequenceCompiler compiler) {
        this.prestateExpressionSignature = prestateExpressionSignature;
        this.prestateExpressionDeclaration = prestateExpressionDeclaration;
        this.poststateExpressionSignature = poststateExpressionSignature;
        this.poststateExpressionDeclarations = poststateExpressionDeclaration;
        this.replacementMap = replacementMap;
        this.compiler = compiler;
    }

    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SpecificationTranslator createTranslator(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Executable executable, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSpecification specification, @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SequenceCompiler compiler) {
        Identifiers identifiers = specification.getIdentifiers();
        RawSignature prestateExpressionSignature = SpecificationTranslator.getExpressionSignature(executable, false);
        RawSignature poststateExpressionSignature = SpecificationTranslator.getExpressionSignature(executable, true);
        ArrayList<String> parameterNames = new ArrayList<String>(identifiers.getParameterNames().size() + 2);
        if (executable instanceof Method) {
            parameterNames.add(identifiers.getReceiverName());
        }
        parameterNames.addAll(identifiers.getParameterNames());
        String prestateExpressionDeclarations = prestateExpressionSignature.getDeclarationArguments(parameterNames);
        parameterNames.add(identifiers.getReturnName());
        String poststateExpressionDeclarations = poststateExpressionSignature.getDeclarationArguments(parameterNames);
        Map<String, String> replacementMap = SpecificationTranslator.createReplacementMap(parameterNames);
        return new SpecificationTranslator(prestateExpressionSignature, prestateExpressionDeclarations, poststateExpressionSignature, poststateExpressionDeclarations, replacementMap, compiler);
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RawSignature getExpressionSignature(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Executable executable, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean postState) {
        boolean isMethod = executable instanceof Method;
        Class<?> declaringClass = executable.getDeclaringClass();
        Class<?> receiverAType = isMethod ? declaringClass : null;
        Class<?>[] parameterTypes = executable.getParameterTypes();
        Class<?> returnType = !postState ? null : (isMethod ? ((Method)executable).getReturnType() : declaringClass);
        String packageName = SpecificationTranslator.renamedPackage(declaringClass.getPackage());
        RawSignature result = SpecificationTranslator.getRawSignature(packageName, receiverAType, parameterTypes, returnType);
        return result;
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RawSignature getRawSignature(@DotSeparatedIdentifiers @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String packageName, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> receiverAType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] parameterTypes, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> returnType) {
        int shift = receiverAType != null ? 1 : 0;
        int length = parameterTypes.length + shift + (returnType != null ? 1 : 0);
        Class[] expressionParameterTypes = new Class[length];
        if (receiverAType != null) {
            expressionParameterTypes[0] = receiverAType;
        }
        System.arraycopy(parameterTypes, 0, expressionParameterTypes, shift, parameterTypes.length);
        if (returnType != null) {
            expressionParameterTypes[expressionParameterTypes.length - 1] = returnType;
        }
        StringJoiner methodName = new StringJoiner("_");
        methodName.add("signature");
        if (receiverAType != null) {
            methodName.add(receiverAType.getSimpleName());
        }
        for (Class<?> parameterType : parameterTypes) {
            methodName.add(RawSignature.classToIdentifier(parameterType));
        }
        return new RawSignature(packageName, receiverAType == null || receiverAType.getSimpleName().isEmpty() ? "ClassName" : receiverAType.getSimpleName(), methodName.toString(), expressionParameterTypes);
    }

    private static @DotSeparatedIdentifiers @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String renamedPackage(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Package aPackage) {
        String packageName = RawSignature.getPackageName(aPackage);
        if (packageName == null) {
            return null;
        }
        if (packageName.startsWith("java.")) {
            packageName = "randoop." + packageName;
        }
        return packageName;
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> createReplacementMap(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> parameterNames) {
        HashMap<String, String> replacementMap = new HashMap<String, String>(CollectionsPlume.mapCapacity(parameterNames));
        for (int i = 0; i < parameterNames.size(); ++i) {
            replacementMap.put(parameterNames.get(i), DUMMY_VARIABLE_BASE_NAME + i);
        }
        return replacementMap;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSpecification createExecutableSpecification(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Executable executable, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSpecification specification, @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SequenceCompiler compiler) {
        SpecificationTranslator st = SpecificationTranslator.createTranslator(executable, specification, compiler);
        return new ExecutableSpecification(st.getGuardExpressions(specification.getPreconditions()), st.getReturnConditions(specification.getPostconditions()), st.getThrowsConditions(specification.getThrowsConditions()));
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableBooleanExpression> getGuardExpressions(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Precondition> preconditions) {
        ArrayList<ExecutableBooleanExpression> guardExpressions = new ArrayList<ExecutableBooleanExpression>(preconditions.size());
        for (Precondition precondition : preconditions) {
            try {
                guardExpressions.add(this.create(precondition.getGuard()));
            }
            catch (RandoopSpecificationError e) {
                if (GenInputsAbstract.ignore_condition_compilation_error) {
                    System.out.println("Warning: discarded uncompilable guard expression: " + e.getMessage());
                    continue;
                }
                throw e;
            }
        }
        return guardExpressions;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GuardPropertyPair> getReturnConditions(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Postcondition> postconditions) {
        ArrayList<GuardPropertyPair> returnConditions = new ArrayList<GuardPropertyPair>(postconditions.size());
        for (Postcondition postcondition : postconditions) {
            try {
                ExecutableBooleanExpression guard = this.create(postcondition.getGuard());
                ExecutableBooleanExpression property = this.create(postcondition.getProperty());
                returnConditions.add(new GuardPropertyPair(guard, property));
            }
            catch (RandoopSpecificationError e) {
                if (GenInputsAbstract.ignore_condition_compilation_error) {
                    System.out.println("Warning: discarding uncompilable poststate expression: " + e.getMessage());
                    continue;
                }
                throw e;
            }
        }
        return returnConditions;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GuardThrowsPair> getThrowsConditions(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ThrowsCondition> throwsConditions) {
        ArrayList<GuardThrowsPair> throwsPairs = new ArrayList<GuardThrowsPair>(throwsConditions.size());
        for (ThrowsCondition throwsCondition : throwsConditions) {
            ClassOrInterfaceType exceptionType;
            try {
                exceptionType = (ClassOrInterfaceType)ClassOrInterfaceType.forName(throwsCondition.getExceptionTypeName());
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                String msg = "Error in specification " + throwsCondition + ". Cannot find exception type: " + e.getMessage();
                Log.logPrintf("%s%n", msg);
                if (GenInputsAbstract.ignore_condition_compilation_error) continue;
                throw new RandoopSpecificationError(msg);
            }
            try {
                ExecutableBooleanExpression guard = this.create(throwsCondition.getGuard());
                ThrowsClause throwsClause = new ThrowsClause(exceptionType, throwsCondition.getDescription());
                throwsPairs.add(new GuardThrowsPair(guard, throwsClause));
            }
            catch (RandoopSpecificationError e) {
                if (GenInputsAbstract.ignore_condition_compilation_error) {
                    System.out.println("Warning: discarding uncompilable throws-expression: " + e.getMessage());
                    continue;
                }
                throw e;
            }
        }
        return throwsPairs;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableBooleanExpression create(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Guard expression) {
        String contractText = Util.replaceWords(expression.getConditionSource(), this.replacementMap);
        return new ExecutableBooleanExpression(this.prestateExpressionSignature, this.prestateExpressionDeclaration, expression.getConditionSource(), contractText, expression.getDescription(), this.compiler);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableBooleanExpression create(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Property expression) {
        String contractText = Util.replaceWords(expression.getConditionSource(), this.replacementMap);
        return new ExecutableBooleanExpression(this.poststateExpressionSignature, this.poststateExpressionDeclarations, expression.getConditionSource(), contractText, expression.getDescription(), this.compiler);
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getPrestateExpressionDeclaration() {
        return this.prestateExpressionDeclaration;
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getPoststateExpressionDeclarations() {
        return this.poststateExpressionDeclarations;
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RawSignature getPoststateExpressionSignature() {
        return this.poststateExpressionSignature;
    }

    @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SequenceCompiler getCompiler() {
        return this.compiler;
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> getReplacementMap() {
        return this.replacementMap;
    }
}

