/*
 * Decompiled with CFR 0.152.
 */
package randoop.condition;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import randoop.com.google.gson.Gson;
import randoop.com.google.gson.GsonBuilder;
import randoop.com.google.gson.reflect.TypeToken;
import randoop.compile.SequenceCompiler;
import randoop.condition.ExecutableSpecification;
import randoop.condition.RandoopSpecificationError;
import randoop.condition.SpecificationTranslator;
import randoop.condition.specification.OperationSignature;
import randoop.condition.specification.OperationSpecification;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.calledmethods.qual.EnsuresCalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.mustcall.qual.Owning;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.ClassGetName;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.reflection.TypeNames;
import randoop.util.MultiMap;
import randoop.util.Util;

@MustCall(value={"close"})
public class SpecificationCollection
implements Closeable {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibleObject, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSpecification> specificationMap;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MultiMap<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSignature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method> signatureToMethods;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibleObject, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method>> overridden;
    @Owning
    private final @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SequenceCompiler compiler;
    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeToken<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSpecification>> LIST_OF_OS_TYPE_TOKEN = new TypeToken<List<OperationSpecification>>(){};
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibleObject, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSpecification> getExecutableSpecificationCache;

    SpecificationCollection(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibleObject, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSpecification> specificationMap, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MultiMap<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSignature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method> signatureToMethods, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibleObject, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method>> overridden) {
        this.specificationMap = specificationMap;
        this.signatureToMethods = signatureToMethods;
        this.overridden = overridden;
        this.getExecutableSpecificationCache = new HashMap<AccessibleObject, ExecutableSpecification>();
        this.compiler = new SequenceCompiler();
    }

    public static @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SpecificationCollection create(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path> specificationFiles) {
        if (specificationFiles == null) {
            return null;
        }
        MultiMap<OperationSignature, Method> signatureToMethods = new MultiMap<OperationSignature, Method>();
        LinkedHashMap<AccessibleObject, OperationSpecification> specificationMap = new LinkedHashMap<AccessibleObject, OperationSpecification>();
        for (Path specificationFile : specificationFiles) {
            SpecificationCollection.readSpecificationFile(specificationFile, specificationMap, signatureToMethods);
        }
        Map<AccessibleObject, Set<Method>> overridden = SpecificationCollection.buildOverridingMap(signatureToMethods);
        return new SpecificationCollection(specificationMap, signatureToMethods, overridden);
    }

    @Override
    @EnsuresCalledMethods(value={"compiler"}, methods={"close"})
    public void close() {
        try {
            this.compiler.close();
        }
        catch (IOException e) {
            throw new RandoopBug(e);
        }
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibleObject, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method>> buildOverridingMap(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MultiMap<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSignature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method> signatureToMethods) {
        HashMap<AccessibleObject, Set<Method>> overridden = new HashMap<AccessibleObject, Set<Method>>();
        for (OperationSignature signature : signatureToMethods.keySet()) {
            Set<Method> methods = signatureToMethods.getValues(signature);
            for (Method method : methods) {
                Class<?> declaringClass = method.getDeclaringClass();
                Set<Method> parents = SpecificationCollection.findOverridden(declaringClass, methods);
                overridden.put(method, parents);
            }
        }
        return overridden;
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method> findOverridden(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> classType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method> methods) {
        HashSet<Method> parents = new HashSet<Method>();
        for (Method method : methods) {
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass == classType || !declaringClass.isAssignableFrom(classType)) continue;
            parents.add(method);
        }
        return parents;
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibleObject getAccessibleObject(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSignature operation) {
        if (operation.isValid()) {
            Class<?> declaringClass;
            List<@ClassGetName String> paramTypeNames = operation.getParameterTypeNames();
            Class[] argTypes = new Class[paramTypeNames.size()];
            for (int i = 0; i < argTypes.length; ++i) {
                String typeName = paramTypeNames.get(i);
                try {
                    argTypes[i] = TypeNames.getTypeForName(typeName);
                    continue;
                }
                catch (Throwable e) {
                    throw new RandoopSpecificationError("Could not load parameter type #" + i + " " + typeName + " in specification operation: " + operation, e);
                }
            }
            String classname = operation.getClassname();
            try {
                declaringClass = TypeNames.getTypeForName(classname);
            }
            catch (Throwable e) {
                throw new RandoopSpecificationError("Could not load declaring class " + classname + " in specification operation: " + operation, e);
            }
            if (operation.isConstructor()) {
                try {
                    return declaringClass.getDeclaredConstructor(argTypes);
                }
                catch (Throwable e) {
                    StringJoiner sj = new StringJoiner(System.lineSeparator());
                    sj.add("Could not load constructor in specification operation: " + operation);
                    sj.add("The constructors are:");
                    for (Constructor<?> c : declaringClass.getDeclaredConstructors()) {
                        sj.add("  " + c);
                    }
                    throw new RandoopSpecificationError(sj.toString(), e);
                }
            }
            try {
                return declaringClass.getDeclaredMethod(operation.getName(), argTypes);
            }
            catch (Throwable e) {
                StringJoiner sj = new StringJoiner(System.lineSeparator());
                sj.add("Could not load method " + operation.getName() + " in specification operation: " + operation);
                sj.add("The methods are:");
                for (Method m4 : declaringClass.getDeclaredMethods()) {
                    sj.add("  " + m4);
                }
                throw new RandoopSpecificationError(sj.toString(), e);
            }
        }
        return null;
    }

    private static void readSpecificationFile(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path specificationFile, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibleObject, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSpecification> specificationMap, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MultiMap<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSignature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method> signatureToMethods) {
        if (specificationFile.toString().toLowerCase(Locale.getDefault()).endsWith(".zip")) {
            SpecificationCollection.readSpecificationZipFile(specificationFile, specificationMap, signatureToMethods);
            return;
        }
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        try (BufferedReader reader = Files.newBufferedReader(specificationFile, StandardCharsets.UTF_8);){
            List specificationList = (List)gson.fromJson((Reader)reader, LIST_OF_OS_TYPE_TOKEN.getType());
            for (OperationSpecification specification : specificationList) {
                OperationSignature operation = specification.getOperation();
                if (operation == null) {
                    throw new Error("operation is null for specification " + specification);
                }
                String duplicateName = specification.getIdentifiers().duplicateName();
                if (duplicateName != null) {
                    throw new RandoopSpecificationError("Duplicate name \"" + duplicateName + "\" in specification: " + specification);
                }
                AccessibleObject accessibleObject = SpecificationCollection.getAccessibleObject(operation);
                specificationMap.put(accessibleObject, specification);
                if (!(accessibleObject instanceof Method)) continue;
                OperationSignature signature = OperationSignature.of(accessibleObject);
                signatureToMethods.add(signature, (Method)accessibleObject);
            }
        }
        catch (IOException e) {
            throw new RandoopSpecificationError("Unable to read specification file " + Util.pathAndAbsolute(specificationFile), e);
        }
        catch (RandoopSpecificationError e) {
            e.setFile(specificationFile);
            throw e;
        }
        catch (Throwable e) {
            System.out.println("Bad specification file:");
            e.printStackTrace(System.out);
            throw new RandoopSpecificationError("Bad specification file " + specificationFile, e);
        }
    }

    private static void readSpecificationZipFile(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path specificationZipFile, final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibleObject, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSpecification> specificationMap, final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MultiMap<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationSignature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method> signatureToMethods) {
        Map myEmptyMap = Collections.emptyMap();
        try {
            URI uri = URI.create("jar:" + specificationZipFile.toUri().toString());
            FileSystem zipFS = FileSystems.newFileSystem(uri, myEmptyMap);
            for (Path root : zipFS.getRootDirectories()) {
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown FileVisitResult visitFile(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path file, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BasicFileAttributes attrs) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IOException {
                        SpecificationCollection.readSpecificationFile(file, specificationMap, signatureToMethods);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown FileVisitResult preVisitDirectory(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path dir, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BasicFileAttributes attrs) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IOException {
                        if (dir.endsWith("__MACOSX")) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        return super.preVisitDirectory(dir, attrs);
                    }
                });
            }
        }
        catch (IOException e) {
            throw new RandoopSpecificationError("Unable to read specification file " + Util.pathAndAbsolute(specificationZipFile), e);
        }
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSpecification getExecutableSpecification(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Executable executable) {
        ExecutableSpecification execSpec = this.getExecutableSpecificationCache.get(executable);
        if (execSpec != null) {
            return execSpec;
        }
        OperationSpecification specification = this.specificationMap.get(executable);
        execSpec = specification == null ? new ExecutableSpecification() : SpecificationTranslator.createExecutableSpecification(executable, specification, this.compiler);
        if (executable instanceof Method) {
            Set<Method> sigSet;
            Method method = (Method)executable;
            Set<Method> parents = this.overridden.get(executable);
            if (parents == null && (sigSet = this.signatureToMethods.getValues(OperationSignature.of(method))) != null) {
                parents = SpecificationCollection.findOverridden(method.getDeclaringClass(), sigSet);
            }
            if (parents == null) {
                throw new Error("parents = null (test #2) for " + executable);
            }
            if (parents != null) {
                for (Method parent : parents) {
                    ExecutableSpecification parentExecSpec = this.getExecutableSpecification(parent);
                    execSpec.addParent(parentExecSpec);
                }
            }
        }
        this.getExecutableSpecificationCache.put(executable, execSpec);
        return execSpec;
    }
}

