/*
 * Decompiled with CFR 0.152.
 */
package randoop.com.github.javaparser.resolution.logic;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import randoop.com.github.javaparser.resolution.TypeSolver;
import randoop.com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import randoop.com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import randoop.com.github.javaparser.resolution.types.ResolvedReferenceType;
import randoop.com.github.javaparser.resolution.types.ResolvedType;
import randoop.com.github.javaparser.resolution.types.ResolvedTypeVariable;
import randoop.com.github.javaparser.resolution.types.ResolvedWildcard;

public class InferenceVariableType
implements ResolvedType {
    private int id;
    private ResolvedTypeParameterDeclaration correspondingTp;
    private Set<ResolvedType> equivalentTypes = new HashSet<ResolvedType>();
    private TypeSolver typeSolver;
    private Set<ResolvedType> superTypes = new HashSet<ResolvedType>();

    public String toString() {
        return "InferenceVariableType{id=" + this.id + '}';
    }

    public void setCorrespondingTp(ResolvedTypeParameterDeclaration correspondingTp) {
        this.correspondingTp = correspondingTp;
    }

    public void registerEquivalentType(ResolvedType type) {
        this.equivalentTypes.add(type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InferenceVariableType)) {
            return false;
        }
        InferenceVariableType that = (InferenceVariableType)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    public InferenceVariableType(int id, TypeSolver typeSolver) {
        this.id = id;
        this.typeSolver = typeSolver;
    }

    @Override
    public String describe() {
        return "InferenceVariable_" + this.id;
    }

    @Override
    public boolean isAssignableBy(ResolvedType other) {
        throw new UnsupportedOperationException();
    }

    private Set<ResolvedType> concreteEquivalentTypesAlsoIndirectly(Set<InferenceVariableType> considered, InferenceVariableType inferenceVariableType) {
        considered.add(inferenceVariableType);
        HashSet<ResolvedType> result = new HashSet<ResolvedType>();
        result.addAll(inferenceVariableType.equivalentTypes.stream().filter(t2 -> !t2.isTypeVariable() && !(t2 instanceof InferenceVariableType)).collect(Collectors.toSet()));
        inferenceVariableType.equivalentTypes.stream().filter(t2 -> t2 instanceof InferenceVariableType).forEach(t2 -> {
            InferenceVariableType ivt = (InferenceVariableType)t2;
            if (!considered.contains(ivt)) {
                result.addAll(this.concreteEquivalentTypesAlsoIndirectly(considered, ivt));
            }
        });
        return result;
    }

    public ResolvedType equivalentType() {
        Set<ResolvedType> concreteEquivalent = this.concreteEquivalentTypesAlsoIndirectly(new HashSet<InferenceVariableType>(), this);
        if (concreteEquivalent.isEmpty()) {
            if (this.correspondingTp == null) {
                return new ReferenceTypeImpl(this.typeSolver.getSolvedJavaLangObject());
            }
            return new ResolvedTypeVariable(this.correspondingTp);
        }
        if (concreteEquivalent.size() == 1) {
            return concreteEquivalent.iterator().next();
        }
        Set notTypeVariables = this.equivalentTypes.stream().filter(t2 -> !t2.isTypeVariable() && !this.hasInferenceVariables((ResolvedType)t2)).collect(Collectors.toSet());
        if (notTypeVariables.size() == 1) {
            return (ResolvedType)notTypeVariables.iterator().next();
        }
        if (notTypeVariables.size() == 0 && !this.superTypes.isEmpty()) {
            if (this.superTypes.size() == 1) {
                return this.superTypes.iterator().next();
            }
            throw new IllegalStateException("Super types are: " + this.superTypes);
        }
        throw new IllegalStateException("Equivalent types are: " + this.equivalentTypes);
    }

    private boolean hasInferenceVariables(ResolvedType type) {
        if (type instanceof InferenceVariableType) {
            return true;
        }
        if (type.isReferenceType()) {
            ResolvedReferenceType refType = type.asReferenceType();
            for (ResolvedType t2 : refType.typeParametersValues()) {
                if (!this.hasInferenceVariables(t2)) continue;
                return true;
            }
            return false;
        }
        if (type.isWildcard()) {
            ResolvedWildcard wildcardType = type.asWildcard();
            return this.hasInferenceVariables(wildcardType.getBoundedType());
        }
        return false;
    }
}

