/*
 * Decompiled with CFR 0.152.
 */
package randoop.com.github.javaparser.printer.lexicalpreservation.changes;

import java.util.Optional;
import randoop.com.github.javaparser.Range;
import randoop.com.github.javaparser.ast.Node;
import randoop.com.github.javaparser.ast.NodeList;
import randoop.com.github.javaparser.ast.observer.ObservableProperty;
import randoop.com.github.javaparser.printer.lexicalpreservation.changes.Change;
import randoop.com.github.javaparser.printer.lexicalpreservation.changes.NoChange;

public class ListRemovalChange
implements Change {
    private final ObservableProperty observableProperty;
    private final int index;

    public ListRemovalChange(ObservableProperty observableProperty, int index) {
        this.observableProperty = observableProperty;
        this.index = index;
    }

    @Override
    public Object getValue(ObservableProperty property, Node node) {
        if (property == this.observableProperty) {
            Object currentRawValue = new NoChange().getValue(property, node);
            if (currentRawValue instanceof Optional) {
                Optional optional = (Optional)currentRawValue;
                currentRawValue = optional.orElse(null);
            }
            if (!(currentRawValue instanceof NodeList)) {
                throw new IllegalStateException("Expected NodeList, found " + currentRawValue.getClass().getCanonicalName());
            }
            NodeList currentNodeList = (NodeList)currentRawValue;
            NodeList newNodeList = new NodeList();
            newNodeList.setParentNode(currentNodeList.getParentNodeForChildren());
            currentNodeList.stream().filter(n -> !this.isSameNode((Node)currentNodeList.get(this.index), (Node)n)).forEach(selectedNode -> newNodeList.add(selectedNode));
            return newNodeList;
        }
        return new NoChange().getValue(property, node);
    }

    private boolean isSameNode(Node n1, Node n2) {
        return n1.equals(n2) && this.isSameRange(n1, n2);
    }

    private boolean isSameRange(Node n1, Node n2) {
        return !n1.hasRange() && !n2.hasRange() || n1.hasRange() && n2.hasRange() && this.isSameRange(n1.getRange().get(), n2.getRange().get());
    }

    private boolean isSameRange(Range r1, Range r2) {
        return r1.equals(r2);
    }

    @Override
    public ObservableProperty getProperty() {
        return this.observableProperty;
    }
}

