/*
 * Decompiled with CFR 0.152.
 */
package randoop.com.github.javaparser.printer.concretesyntaxmodel;

import randoop.com.github.javaparser.GeneratedJavaParserConstants;
import randoop.com.github.javaparser.TokenTypes;
import randoop.com.github.javaparser.ast.Node;
import randoop.com.github.javaparser.printer.SourcePrinter;
import randoop.com.github.javaparser.printer.concretesyntaxmodel.CsmElement;
import randoop.com.github.javaparser.printer.lexicalpreservation.TextElement;
import randoop.com.github.javaparser.printer.lexicalpreservation.TokenTextElement;
import randoop.com.github.javaparser.utils.LineSeparator;

public class CsmToken
implements CsmElement {
    private final int tokenType;
    private String content;

    public int getTokenType() {
        return this.tokenType;
    }

    public String getContent() {
        return this.content;
    }

    public CsmToken(int tokenType) {
        this.tokenType = tokenType;
        this.content = GeneratedJavaParserConstants.tokenImage[tokenType];
        if (this.content.startsWith("\"")) {
            this.content = this.content.substring(1, this.content.length() - 1);
        }
        if (TokenTypes.isEndOfLineToken(tokenType)) {
            this.content = LineSeparator.lookupEscaped(this.content).get().asRawString();
        } else if (TokenTypes.isWhitespaceButNotEndOfLine(tokenType)) {
            this.content = " ";
        }
    }

    public CsmToken(int tokenType, String content) {
        this.tokenType = tokenType;
        this.content = content;
    }

    @Override
    public void prettyPrint(Node node, SourcePrinter printer) {
        if (TokenTypes.isEndOfLineToken(this.tokenType)) {
            printer.println();
        } else {
            printer.print(this.getContent());
        }
    }

    public String toString() {
        return String.format("%s(property:%s)", this.getClass().getSimpleName(), this.content);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CsmToken csmToken = (CsmToken)o;
        if (this.tokenType != csmToken.tokenType) {
            return false;
        }
        return !(this.content != null ? !this.content.equals(csmToken.content) : csmToken.content != null);
    }

    public int hashCode() {
        int result = this.tokenType;
        result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
        return result;
    }

    public boolean isWhiteSpace() {
        return TokenTypes.isWhitespace(this.tokenType);
    }

    public boolean isWhiteSpaceNotEol() {
        return this.isWhiteSpace() && !this.isNewLine();
    }

    public boolean isNewLine() {
        return TokenTypes.isEndOfLineToken(this.tokenType);
    }

    @Override
    public boolean isCorrespondingElement(TextElement textElement) {
        return textElement instanceof TokenTextElement && ((TokenTextElement)textElement).getTokenKind() == this.getTokenType() && ((TokenTextElement)textElement).getText().equals(this.getContent());
    }
}

