/*
 * Decompiled with CFR 0.152.
 */
package randoop.com.github.javaparser.printer.concretesyntaxmodel;

import randoop.com.github.javaparser.GeneratedJavaParserConstants;
import randoop.com.github.javaparser.ast.Node;
import randoop.com.github.javaparser.ast.expr.IntegerLiteralExpr;
import randoop.com.github.javaparser.ast.observer.ObservableProperty;
import randoop.com.github.javaparser.printer.SourcePrinter;
import randoop.com.github.javaparser.printer.concretesyntaxmodel.CsmElement;
import randoop.com.github.javaparser.printer.concretesyntaxmodel.PrintingHelper;
import randoop.com.github.javaparser.utils.CodeGenerationUtils;

public class CsmAttribute
implements CsmElement {
    private final ObservableProperty property;

    public ObservableProperty getProperty() {
        return this.property;
    }

    public CsmAttribute(ObservableProperty property) {
        this.property = property;
    }

    @Override
    public void prettyPrint(Node node, SourcePrinter printer) {
        Object value = this.property.getRawValue(node);
        printer.print(PrintingHelper.printToString(value));
    }

    public int getTokenType(Node node, String text, String tokenText) {
        switch (this.property) {
            case IDENTIFIER: {
                return 98;
            }
            case TYPE: {
                String expectedImage = "\"" + text.toLowerCase() + "\"";
                for (int i = 0; i < GeneratedJavaParserConstants.tokenImage.length; ++i) {
                    if (!GeneratedJavaParserConstants.tokenImage[i].equals(expectedImage)) continue;
                    return i;
                }
                throw new RuntimeException(CodeGenerationUtils.f("Attribute '%s' does not corresponding to any expected value. Text: %s", this.property.camelCaseName(), text));
            }
            case KEYWORD: 
            case OPERATOR: {
                String expectedImage = "\"" + tokenText.toLowerCase() + "\"";
                for (int i = 0; i < GeneratedJavaParserConstants.tokenImage.length; ++i) {
                    if (!GeneratedJavaParserConstants.tokenImage[i].equals(expectedImage)) continue;
                    return i;
                }
                throw new RuntimeException(CodeGenerationUtils.f("Attribute '%s' does not corresponding to any expected value. Text: %s", this.property.camelCaseName(), tokenText));
            }
            case VALUE: {
                if (node instanceof IntegerLiteralExpr) {
                    return 81;
                }
            }
            case NAME: {
                return 98;
            }
        }
        throw new UnsupportedOperationException("getTokenType does not know how to handle property " + (Object)((Object)this.property) + " with text: " + text);
    }

    public String toString() {
        return String.format("%s(property:%s)", new Object[]{this.getClass().getSimpleName(), this.getProperty()});
    }
}

