/*
 * Decompiled with CFR 0.152.
 */
package randoop.com.github.javaparser.ast.expr;

import java.util.Optional;
import java.util.function.Consumer;
import randoop.com.github.javaparser.TokenRange;
import randoop.com.github.javaparser.ast.AllFieldsConstructor;
import randoop.com.github.javaparser.ast.expr.LiteralStringValueExpr;
import randoop.com.github.javaparser.ast.visitor.CloneVisitor;
import randoop.com.github.javaparser.ast.visitor.GenericVisitor;
import randoop.com.github.javaparser.ast.visitor.VoidVisitor;
import randoop.com.github.javaparser.metamodel.JavaParserMetaModel;
import randoop.com.github.javaparser.metamodel.StringLiteralExprMetaModel;
import randoop.com.github.javaparser.utils.StringEscapeUtils;
import randoop.com.github.javaparser.utils.Utils;

public class StringLiteralExpr
extends LiteralStringValueExpr {
    public StringLiteralExpr() {
        this(null, "empty");
    }

    @AllFieldsConstructor
    public StringLiteralExpr(String value) {
        this(null, Utils.escapeEndOfLines(value));
    }

    public StringLiteralExpr(TokenRange tokenRange, String value) {
        super(tokenRange, value);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public StringLiteralExpr setEscapedValue(String value) {
        this.value = Utils.escapeEndOfLines(value);
        return this;
    }

    public String asString() {
        return StringEscapeUtils.unescapeJava(this.value);
    }

    public StringLiteralExpr setString(String value) {
        this.value = StringEscapeUtils.escapeJava(value);
        return this;
    }

    @Override
    public StringLiteralExpr clone() {
        return (StringLiteralExpr)this.accept(new CloneVisitor(), null);
    }

    @Override
    public StringLiteralExprMetaModel getMetaModel() {
        return JavaParserMetaModel.stringLiteralExprMetaModel;
    }

    @Override
    public boolean isStringLiteralExpr() {
        return true;
    }

    @Override
    public StringLiteralExpr asStringLiteralExpr() {
        return this;
    }

    @Override
    public void ifStringLiteralExpr(Consumer<StringLiteralExpr> action) {
        action.accept(this);
    }

    @Override
    public Optional<StringLiteralExpr> toStringLiteralExpr() {
        return Optional.of(this);
    }
}

