/*
 * Decompiled with CFR 0.152.
 */
package randoop.com.github.javaparser.ast.expr;

import java.util.Optional;
import java.util.function.Consumer;
import randoop.com.github.javaparser.TokenRange;
import randoop.com.github.javaparser.ast.AllFieldsConstructor;
import randoop.com.github.javaparser.ast.Node;
import randoop.com.github.javaparser.ast.expr.Expression;
import randoop.com.github.javaparser.ast.expr.NameExpr;
import randoop.com.github.javaparser.ast.expr.PatternExpr;
import randoop.com.github.javaparser.ast.expr.SimpleName;
import randoop.com.github.javaparser.ast.nodeTypes.NodeWithExpression;
import randoop.com.github.javaparser.ast.nodeTypes.NodeWithType;
import randoop.com.github.javaparser.ast.observer.ObservableProperty;
import randoop.com.github.javaparser.ast.type.ClassOrInterfaceType;
import randoop.com.github.javaparser.ast.type.ReferenceType;
import randoop.com.github.javaparser.ast.visitor.CloneVisitor;
import randoop.com.github.javaparser.ast.visitor.GenericVisitor;
import randoop.com.github.javaparser.ast.visitor.VoidVisitor;
import randoop.com.github.javaparser.metamodel.InstanceOfExprMetaModel;
import randoop.com.github.javaparser.metamodel.JavaParserMetaModel;
import randoop.com.github.javaparser.metamodel.OptionalProperty;
import randoop.com.github.javaparser.utils.Utils;

public class InstanceOfExpr
extends Expression
implements NodeWithType<InstanceOfExpr, ReferenceType>,
NodeWithExpression<InstanceOfExpr> {
    private Expression expression;
    @OptionalProperty
    private PatternExpr pattern;
    private ReferenceType type;

    public InstanceOfExpr() {
        this(null, new NameExpr(), new ClassOrInterfaceType(), null);
    }

    public InstanceOfExpr(Expression expression, ReferenceType type) {
        this(null, expression, type, null);
    }

    @AllFieldsConstructor
    public InstanceOfExpr(Expression expression, ReferenceType type, PatternExpr pattern) {
        this(null, expression, type, pattern);
    }

    public InstanceOfExpr(TokenRange tokenRange, Expression expression, ReferenceType type, PatternExpr pattern) {
        super(tokenRange);
        this.setExpression(expression);
        this.setType(type);
        this.setPattern(pattern);
        this.customInitialization();
    }

    public Optional<SimpleName> getName() {
        if (this.pattern == null) {
            return Optional.empty();
        }
        if (!this.pattern.isTypePatternExpr()) {
            return Optional.empty();
        }
        return Optional.of(this.pattern.asTypePatternExpr().getName());
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public InstanceOfExpr asInstanceOfExpr() {
        return this;
    }

    @Override
    public InstanceOfExpr clone() {
        return (InstanceOfExpr)this.accept(new CloneVisitor(), null);
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public InstanceOfExprMetaModel getMetaModel() {
        return JavaParserMetaModel.instanceOfExprMetaModel;
    }

    public Optional<PatternExpr> getPattern() {
        return Optional.ofNullable(this.pattern);
    }

    @Override
    public ReferenceType getType() {
        return this.type;
    }

    @Override
    public void ifInstanceOfExpr(Consumer<InstanceOfExpr> action) {
        action.accept(this);
    }

    @Override
    public boolean isInstanceOfExpr() {
        return true;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        if (this.pattern != null && node == this.pattern) {
            this.removePattern();
            return true;
        }
        return super.remove(node);
    }

    public InstanceOfExpr removePattern() {
        return this.setPattern(null);
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        if (node == this.expression) {
            this.setExpression((Expression)replacementNode);
            return true;
        }
        if (this.pattern != null && node == this.pattern) {
            this.setPattern((PatternExpr)replacementNode);
            return true;
        }
        if (node == this.type) {
            this.setType((ReferenceType)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public InstanceOfExpr setExpression(Expression expression) {
        Utils.assertNotNull(expression);
        if (expression == this.expression) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.EXPRESSION, this.expression, expression);
        if (this.expression != null) {
            this.expression.setParentNode(null);
        }
        this.expression = expression;
        this.setAsParentNodeOf(expression);
        return this;
    }

    public InstanceOfExpr setPattern(PatternExpr pattern) {
        if (pattern == this.pattern) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.PATTERN, this.pattern, pattern);
        if (this.pattern != null) {
            this.pattern.setParentNode(null);
        }
        this.pattern = pattern;
        this.setAsParentNodeOf(pattern);
        return this;
    }

    @Override
    public InstanceOfExpr setType(ReferenceType type) {
        Utils.assertNotNull(type);
        if (type == this.type) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.TYPE, this.type, type);
        if (this.type != null) {
            this.type.setParentNode(null);
        }
        this.type = type;
        this.setAsParentNodeOf(type);
        return this;
    }

    @Override
    public Optional<InstanceOfExpr> toInstanceOfExpr() {
        return Optional.of(this);
    }
}

