/*
 * Decompiled with CFR 0.152.
 */
package randoop;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.types.Type;
import randoop.util.CheckpointingMultiMap;
import randoop.util.CheckpointingSet;
import randoop.util.IMultiMap;
import randoop.util.MultiMap;

public class SubTypeSet {
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type> types;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IMultiMap<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type> subTypes;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean supportsCheckpoints;

    public SubTypeSet(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean supportsCheckpoints) {
        if (supportsCheckpoints) {
            this.supportsCheckpoints = true;
            this.subTypes = new CheckpointingMultiMap<Type, Type>();
            this.types = new CheckpointingSet<Type>();
        } else {
            this.supportsCheckpoints = false;
            this.subTypes = new MultiMap<Type, Type>();
            this.types = new LinkedHashSet<Type>();
        }
    }

    public void mark() {
        if (!this.supportsCheckpoints) {
            throw new RuntimeException("Operation not supported.");
        }
        ((CheckpointingMultiMap)this.subTypes).mark();
        ((CheckpointingSet)this.types).mark();
    }

    public void undoLastStep() {
        if (!this.supportsCheckpoints) {
            throw new RuntimeException("Operation not supported.");
        }
        ((CheckpointingMultiMap)this.subTypes).undoToLastMark();
        ((CheckpointingSet)this.types).undoToLastMark();
    }

    public void add(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type c) {
        if (c == null) {
            throw new IllegalArgumentException("c cannot be null.");
        }
        if (this.types.contains(c)) {
            return;
        }
        this.types.add(c);
        for (Type cls : this.subTypes.keySet()) {
            if (!cls.isAssignableFrom(c) || this.subTypes.getValues(cls).contains(c)) continue;
            this.subTypes.add(cls, c);
        }
    }

    private void addQueryType(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type type) {
        if (type == null) {
            throw new IllegalArgumentException("c cannot be null.");
        }
        Set<Type> keySet = this.subTypes.keySet();
        if (keySet.contains(type)) {
            return;
        }
        LinkedHashSet<Type> compatibleTypes = new LinkedHashSet<Type>();
        for (Type t2 : this.types) {
            if (!type.isAssignableFrom(t2)) continue;
            compatibleTypes.add(t2);
        }
        for (Type cls : compatibleTypes) {
            this.subTypes.add(type, cls);
        }
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type> getMatches(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type type) {
        if (!this.subTypes.keySet().contains(type)) {
            this.addQueryType(type);
        }
        return Collections.unmodifiableSet(this.subTypes.getValues(type));
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int size() {
        return this.types.size();
    }
}

