/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.util;

import coveredclass.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import coveredclass.org.checkerframework.checker.formatter.qual.FormatBottom;
import coveredclass.org.checkerframework.checker.formatter.qual.UnknownFormat;
import coveredclass.org.checkerframework.checker.index.qual.LessThanUnknown;
import coveredclass.org.checkerframework.checker.index.qual.LowerBoundUnknown;
import coveredclass.org.checkerframework.checker.index.qual.SameLenUnknown;
import coveredclass.org.checkerframework.checker.index.qual.SearchIndexUnknown;
import coveredclass.org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import coveredclass.org.checkerframework.checker.index.qual.UpperBoundUnknown;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.lock.qual.GuardSatisfied;
import coveredclass.org.checkerframework.checker.lock.qual.GuardedBy;
import coveredclass.org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import coveredclass.org.checkerframework.checker.mustcall.qual.MustCall;
import coveredclass.org.checkerframework.checker.nonempty.qual.EnsuresNonEmpty;
import coveredclass.org.checkerframework.checker.nonempty.qual.EnsuresNonEmptyIf;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.regex.qual.UnknownRegex;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.checker.signedness.qual.Signed;
import coveredclass.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import coveredclass.org.checkerframework.common.initializedfields.qual.InitializedFields;
import coveredclass.org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import coveredclass.org.checkerframework.common.value.qual.UnknownVal;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import java.util.LinkedHashSet;
import org.plumelib.util.AbstractMostlySingletonSet;

public final class MostlySingletonSet<@FormatBottom T>
extends AbstractMostlySingletonSet<T> {
    public MostlySingletonSet() {
        super(AbstractMostlySingletonSet.State.EMPTY);
    }

    public MostlySingletonSet(T value) {
        super(AbstractMostlySingletonSet.State.SINGLETON, value);
    }

    @Override
    @EnsuresNonEmpty(value={"this"})
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean add(@GuardSatisfied MostlySingletonSet<T> this, T e) {
        switch (this.state) {
            case EMPTY: {
                this.state = AbstractMostlySingletonSet.State.SINGLETON;
                this.value = e;
                return true;
            }
            case SINGLETON: {
                assert (this.value != null) : "@AssumeAssertion(nullness): SINGLETON => value != null";
                if (this.value.equals(e)) {
                    return false;
                }
                this.makeNonSingleton();
            }
            case ANY: {
                assert (this.set != null) : "@AssumeAssertion(nullness): ANY => value != null";
                return this.set.add(e);
            }
        }
        throw new IllegalStateException("Unhandled state " + (Object)((Object)this.state));
    }

    private void makeNonSingleton() {
        this.state = AbstractMostlySingletonSet.State.ANY;
        this.set = new LinkedHashSet();
        assert (this.value != null) : "@AssumeAssertion(nullness): SINGLETON => value != null";
        this.set.add(this.value);
        this.value = null;
    }

    @Override
    @EnsuresNonEmptyIf(result=true, expression={"this"})
    @Pure
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean contains(@GuardSatisfied MostlySingletonSet<T> this, @GuardSatisfied @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object o) {
        switch (this.state) {
            case EMPTY: {
                return false;
            }
            case SINGLETON: {
                assert (this.value != null) : "@AssumeAssertion(nullness): SINGLETON => value != null";
                return this.value.equals(o);
            }
            case ANY: {
                assert (this.set != null) : "@AssumeAssertion(nullness): set initialized before";
                return this.set.contains(o);
            }
        }
        throw new IllegalStateException("Unhandled state " + (Object)((Object)this.state));
    }
}

