/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.util;

import coveredclass.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import coveredclass.org.checkerframework.checker.formatter.qual.FormatBottom;
import coveredclass.org.checkerframework.checker.formatter.qual.UnknownFormat;
import coveredclass.org.checkerframework.checker.index.qual.LessThanUnknown;
import coveredclass.org.checkerframework.checker.index.qual.LowerBoundUnknown;
import coveredclass.org.checkerframework.checker.index.qual.SameLenUnknown;
import coveredclass.org.checkerframework.checker.index.qual.SearchIndexUnknown;
import coveredclass.org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import coveredclass.org.checkerframework.checker.index.qual.UpperBoundUnknown;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.FindDistinct;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.lock.qual.GuardSatisfied;
import coveredclass.org.checkerframework.checker.lock.qual.GuardedBy;
import coveredclass.org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import coveredclass.org.checkerframework.checker.mustcall.qual.MustCall;
import coveredclass.org.checkerframework.checker.nonempty.qual.EnsuresNonEmpty;
import coveredclass.org.checkerframework.checker.nonempty.qual.EnsuresNonEmptyIf;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.regex.qual.UnknownRegex;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.checker.signedness.qual.Signed;
import coveredclass.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import coveredclass.org.checkerframework.common.initializedfields.qual.InitializedFields;
import coveredclass.org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import coveredclass.org.checkerframework.common.value.qual.UnknownVal;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import java.util.Collections;
import java.util.IdentityHashMap;
import org.plumelib.util.AbstractMostlySingletonSet;

public final class IdentityMostlySingletonSet<@FormatBottom T>
extends AbstractMostlySingletonSet<T> {
    public IdentityMostlySingletonSet() {
        super(AbstractMostlySingletonSet.State.EMPTY);
    }

    public IdentityMostlySingletonSet(T value) {
        super(AbstractMostlySingletonSet.State.SINGLETON, value);
    }

    @Override
    @EnsuresNonEmpty(value={"this"})
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean add(@GuardSatisfied IdentityMostlySingletonSet<T> this, @FindDistinct T e) {
        switch (this.state) {
            case EMPTY: {
                this.state = AbstractMostlySingletonSet.State.SINGLETON;
                this.value = e;
                return true;
            }
            case SINGLETON: {
                if (this.value == e) {
                    return false;
                }
                this.makeNonSingleton();
            }
            case ANY: {
                assert (this.set != null) : "@AssumeAssertion(nullness): set initialized before";
                return this.set.add(e);
            }
        }
        throw new IllegalStateException("Unhandled state " + (Object)((Object)this.state));
    }

    private void makeNonSingleton(@GuardSatisfied IdentityMostlySingletonSet<T> this) {
        this.state = AbstractMostlySingletonSet.State.ANY;
        this.set = Collections.newSetFromMap(new IdentityHashMap(4));
        assert (this.value != null) : "@AssumeAssertion(nullness): previous add is non-null";
        this.set.add(this.value);
        this.value = null;
    }

    @Override
    @EnsuresNonEmptyIf(result=true, expression={"this"})
    @Pure
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean contains(@GuardSatisfied IdentityMostlySingletonSet<T> this, @GuardSatisfied @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object o) {
        switch (this.state) {
            case EMPTY: {
                return false;
            }
            case SINGLETON: {
                return o == this.value;
            }
            case ANY: {
                assert (this.set != null) : "@AssumeAssertion(nullness): set initialized before";
                return this.set.contains(o);
            }
        }
        throw new IllegalStateException("Unhandled state " + (Object)((Object)this.state));
    }
}

