/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.util;

import coveredclass.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import coveredclass.org.checkerframework.checker.formatter.qual.UnknownFormat;
import coveredclass.org.checkerframework.checker.index.qual.LessThanUnknown;
import coveredclass.org.checkerframework.checker.index.qual.LowerBoundUnknown;
import coveredclass.org.checkerframework.checker.index.qual.SameLenUnknown;
import coveredclass.org.checkerframework.checker.index.qual.SearchIndexUnknown;
import coveredclass.org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import coveredclass.org.checkerframework.checker.index.qual.UpperBoundUnknown;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.lock.qual.GuardedBy;
import coveredclass.org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import coveredclass.org.checkerframework.checker.mustcall.qual.MustCall;
import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.regex.qual.UnknownRegex;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.checker.signedness.qual.Signed;
import coveredclass.org.checkerframework.common.initializedfields.qual.InitializedFields;
import coveredclass.org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import coveredclass.org.checkerframework.common.value.qual.UnknownVal;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DumpHeap {
    private static volatile @MonotonicNonNull @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Object hotspotMBean;
    private static @MonotonicNonNull @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Method dumpHeapMethod;

    private DumpHeap() {
        throw new Error("Do not instantiate");
    }

    @EnsuresNonNull(value={"hotspotMBean", "dumpHeapMethod"})
    private static synchronized void initializeFields() {
        try {
            Class<?> mxbeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            hotspotMBean = ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), "com.sun.management:type=HotSpotDiagnostic", mxbeanClass);
            dumpHeapMethod = mxbeanClass.getMethod("dumpHeap", String.class, Boolean.TYPE);
        }
        catch (IOException | ClassNotFoundException | NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    public static void dumpHeap(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) String fileName) {
        DumpHeap.dumpHeap(fileName, true);
    }

    public static void dumpHeap(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) String fileName, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean live) {
        DumpHeap.initializeFields();
        File heapFile = new File(fileName);
        if (heapFile.exists()) {
            heapFile.delete();
        }
        try {
            dumpHeapMethod.invoke(hotspotMBean, fileName, live);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Error(e);
        }
    }
}

