/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KotlinSMAP {
    private final ArrayList<Mapping> mappings = new ArrayList();
    private static final Pattern LINE_INFO_PATTERN = Pattern.compile("([0-9]++)(#[0-9]++)?+(,[0-9]++)?+:([0-9]++)(,[0-9]++)?+");
    private static final Pattern FILE_INFO_PATTERN = Pattern.compile("\\+ ([0-9]++) (.++)");

    public List<Mapping> mappings() {
        return this.mappings;
    }

    public KotlinSMAP(String sourceFileName, String smap) {
        try {
            Matcher m4;
            String line;
            BufferedReader br = new BufferedReader(new StringReader(smap));
            KotlinSMAP.expectLine(br, "SMAP");
            KotlinSMAP.expectLine(br, sourceFileName);
            KotlinSMAP.expectLine(br, "Kotlin");
            KotlinSMAP.expectLine(br, "*S Kotlin");
            KotlinSMAP.expectLine(br, "*F");
            HashMap<Integer, String> inputClassNames = new HashMap<Integer, String>();
            while (!"*L".equals(line = br.readLine())) {
                m4 = FILE_INFO_PATTERN.matcher(line);
                if (!m4.matches()) {
                    throw new IllegalStateException("Unexpected SMAP line: " + line);
                }
                int id = Integer.parseInt(m4.group(1));
                String className = br.readLine();
                inputClassNames.put(id, className);
            }
            while (!(line = br.readLine()).equals("*E") && !line.equals("*S KotlinDebug")) {
                m4 = LINE_INFO_PATTERN.matcher(line);
                if (!m4.matches()) {
                    throw new IllegalStateException("Unexpected SMAP line: " + line);
                }
                int inputStartLine = Integer.parseInt(m4.group(1));
                int lineFileID = Integer.parseInt(m4.group(2).substring(1));
                String repeatCountOptional = m4.group(3);
                int repeatCount = repeatCountOptional != null ? Integer.parseInt(repeatCountOptional.substring(1)) : 1;
                int outputStartLine = Integer.parseInt(m4.group(4));
                this.mappings.add(new Mapping((String)inputClassNames.get(lineFileID), inputStartLine, repeatCount, outputStartLine));
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void expectLine(BufferedReader br, String expected) throws IOException {
        String line = br.readLine();
        if (!expected.equals(line)) {
            throw new IllegalStateException("Unexpected SMAP line: " + line);
        }
    }

    public static final class Mapping {
        private final String inputClassName;
        private final int inputStartLine;
        private final int repeatCount;
        private final int outputStartLine;

        Mapping(String inputClassName, int inputStartLine, int repeatCount, int outputStartLine) {
            this.inputClassName = inputClassName;
            this.inputStartLine = inputStartLine;
            this.repeatCount = repeatCount;
            this.outputStartLine = outputStartLine;
        }

        public String inputClassName() {
            return this.inputClassName;
        }

        public int inputStartLine() {
            return this.inputStartLine;
        }

        public int repeatCount() {
            return this.repeatCount;
        }

        public int outputStartLine() {
            return this.outputStartLine;
        }
    }
}

