/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import java.util.ArrayList;
import java.util.Iterator;
import org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;

final class KotlinCoroutineFilter
implements IFilter {
    KotlinCoroutineFilter() {
    }

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        new Matcher().match(methodNode, output);
        new Matcher().matchOptimizedTailCall(methodNode, output);
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        private void matchOptimizedTailCall(MethodNode methodNode, IFilterOutput output) {
            Iterator i$ = methodNode.instructions.iterator();
            while (i$.hasNext()) {
                AbstractInsnNode i;
                this.cursor = i = (AbstractInsnNode)i$.next();
                this.nextIs(89);
                this.nextIsInvoke(184, "kotlin/coroutines/intrinsics/IntrinsicsKt", "getCOROUTINE_SUSPENDED", "()Ljava/lang/Object;");
                this.nextIs(166);
                this.nextIs(176);
                this.nextIs(87);
                if (this.cursor == null) continue;
                output.ignore(i.getNext(), this.cursor);
            }
        }

        private void match(MethodNode methodNode, IFilterOutput output) {
            TableSwitchInsnNode s2;
            this.cursor = Matcher.skipNonOpcodes(methodNode.instructions.getFirst());
            if (this.cursor == null || this.cursor.getOpcode() != 184) {
                this.cursor = null;
            } else {
                MethodInsnNode m4 = (MethodInsnNode)this.cursor;
                if (!("kotlin/coroutines/intrinsics/IntrinsicsKt".equals(m4.owner) && "getCOROUTINE_SUSPENDED".equals(m4.name) && "()Ljava/lang/Object;".equals(m4.desc))) {
                    this.cursor = null;
                }
            }
            if (this.cursor == null) {
                this.cursor = Matcher.skipNonOpcodes(methodNode.instructions.getFirst());
                this.nextIsCreateStateInstance();
                this.nextIsInvoke(184, "kotlin/coroutines/intrinsics/IntrinsicsKt", "getCOROUTINE_SUSPENDED", "()Ljava/lang/Object;");
            }
            if (this.cursor != null && 87 == Matcher.skipNonOpcodes(this.cursor.getNext()).getOpcode()) {
                this.nextIs(87);
                s2 = this.nextIsStateSwitch();
                if (s2 == null || s2.labels.size() != 1) {
                    return;
                }
            } else {
                this.nextIsVar(58, "COROUTINE_SUSPENDED");
                s2 = this.nextIsStateSwitch();
                if (s2 == null) {
                    return;
                }
            }
            ArrayList<AbstractInsnNode> ignore = new ArrayList<AbstractInsnNode>(s2.labels.size() * 2);
            this.nextIs(25);
            this.nextIsThrowOnFailure();
            if (this.cursor == null) {
                return;
            }
            ignore.add(methodNode.instructions.getFirst());
            ignore.add(this.cursor);
            int suspensionPoint = 1;
            block0: for (AbstractInsnNode i = this.cursor; i != null && suspensionPoint < s2.labels.size(); i = i.getNext()) {
                this.cursor = i;
                this.nextIsVar(25, "COROUTINE_SUSPENDED");
                this.nextIs(166);
                if (this.cursor == null) continue;
                AbstractInsnNode continuationAfterLoadedResult = Matcher.skipNonOpcodes(((JumpInsnNode)this.cursor).label);
                this.nextIsVar(25, "COROUTINE_SUSPENDED");
                this.nextIs(176);
                if (this.cursor == null || Matcher.skipNonOpcodes(this.cursor.getNext()) != Matcher.skipNonOpcodes(s2.labels.get(suspensionPoint))) continue;
                for (AbstractInsnNode j = i; j != null; j = j.getNext()) {
                    this.cursor = j;
                    this.nextIs(25);
                    this.nextIsThrowOnFailure();
                    this.nextIs(25);
                    if (this.cursor == null || Matcher.skipNonOpcodes(this.cursor.getNext()) != continuationAfterLoadedResult) continue;
                    ignore.add(i);
                    ignore.add(this.cursor);
                    ++suspensionPoint;
                    continue block0;
                }
            }
            this.cursor = s2.dflt;
            this.nextIsType(187, "java/lang/IllegalStateException");
            this.nextIs(89);
            this.nextIs(18);
            if (this.cursor == null) {
                return;
            }
            if (!((LdcInsnNode)this.cursor).cst.equals("call to 'resume' before 'invoke' with coroutine")) {
                return;
            }
            this.nextIsInvoke(183, "java/lang/IllegalStateException", "<init>", "(Ljava/lang/String;)V");
            this.nextIs(191);
            if (this.cursor == null) {
                return;
            }
            output.ignore(s2.dflt, this.cursor);
            for (int i = 0; i < ignore.size(); i += 2) {
                output.ignore((AbstractInsnNode)ignore.get(i), (AbstractInsnNode)ignore.get(i + 1));
            }
        }

        private TableSwitchInsnNode nextIsStateSwitch() {
            this.nextIsVar(25, "this");
            this.nextIs(180);
            this.nextIs(170);
            if (this.cursor == null) {
                return null;
            }
            return (TableSwitchInsnNode)this.cursor;
        }

        private void nextIsThrowOnFailure() {
            AbstractInsnNode c = this.cursor;
            this.nextIsInvoke(184, "kotlin/ResultKt", "throwOnFailure", "(Ljava/lang/Object;)V");
            if (this.cursor == null) {
                this.cursor = c;
                this.nextIs(89);
                this.nextIsType(193, "kotlin/Result$Failure");
                this.nextIs(153);
                this.nextIsType(192, "kotlin/Result$Failure");
                this.nextIs(180);
                this.nextIs(191);
                this.nextIs(87);
            }
        }

        private void nextIsCreateStateInstance() {
            this.nextIs(193);
            this.nextIs(153);
            if (this.cursor == null) {
                return;
            }
            AbstractInsnNode createStateInstance = Matcher.skipNonOpcodes(((JumpInsnNode)this.cursor).label);
            this.nextIs(25);
            this.nextIs(192);
            this.nextIs(58);
            this.nextIs(25);
            this.nextIs(180);
            this.nextIs(18);
            this.nextIs(126);
            this.nextIs(153);
            if (this.cursor == null || Matcher.skipNonOpcodes(((JumpInsnNode)this.cursor).label) != createStateInstance) {
                return;
            }
            this.nextIs(25);
            this.nextIs(89);
            this.nextIs(180);
            this.nextIs(18);
            this.nextIs(100);
            this.nextIs(181);
            this.nextIs(167);
            if (this.cursor == null) {
                return;
            }
            AbstractInsnNode afterCoroutineStateCreated = Matcher.skipNonOpcodes(((JumpInsnNode)this.cursor).label);
            if (Matcher.skipNonOpcodes(this.cursor.getNext()) != createStateInstance) {
                return;
            }
            this.cursor = afterCoroutineStateCreated;
            this.nextIs(180);
            this.nextIs(58);
        }
    }
}

