/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.internal.analysis.CounterImpl;
import org.jacoco.core.internal.analysis.MethodCoverageImpl;
import org.jacoco.core.internal.analysis.SourceNodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassCoverageImpl
extends SourceNodeImpl
implements IClassCoverage {
    private final long id;
    private final boolean noMatch;
    private final Collection<IMethodCoverage> methods;
    private String signature;
    private String superName;
    private String[] interfaces;
    private String sourceFileName;
    private Collection<SourceNodeImpl> fragments = Collections.emptyList();

    public ClassCoverageImpl(String name, long id, boolean noMatch) {
        super(ICoverageNode.ElementType.CLASS, name);
        this.id = id;
        this.noMatch = noMatch;
        this.methods = new ArrayList<IMethodCoverage>();
    }

    public void addMethod(IMethodCoverage method) {
        this.methods.add(method);
        this.increment(method);
        this.classCounter = this.methodCounter.getCoveredCount() > 0 ? CounterImpl.COUNTER_0_1 : CounterImpl.COUNTER_1_0;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void setSuperName(String superName) {
        this.superName = superName;
    }

    public void setInterfaces(String[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public Collection<SourceNodeImpl> getFragments() {
        return this.fragments;
    }

    public void setFragments(Collection<SourceNodeImpl> fragments) {
        this.fragments = fragments;
    }

    @Override
    public boolean applyFragment(SourceNodeImpl fragment) {
        super.applyFragment(fragment);
        for (IMethodCoverage methodCoverage : this.methods) {
            int mm4 = methodCoverage.getMethodCounter().getMissedCount();
            int cm = methodCoverage.getMethodCounter().getCoveredCount();
            int mc = methodCoverage.getComplexityCounter().getMissedCount();
            int cc = methodCoverage.getComplexityCounter().getCoveredCount();
            if (!((MethodCoverageImpl)methodCoverage).applyFragment(fragment)) continue;
            this.methodCounter = this.methodCounter.increment(methodCoverage.getMethodCounter().getMissedCount() - mm4, methodCoverage.getMethodCounter().getCoveredCount() - cm);
            this.complexityCounter = this.complexityCounter.increment(methodCoverage.getComplexityCounter().getMissedCount() - mc, methodCoverage.getComplexityCounter().getCoveredCount() - cc);
        }
        this.classCounter = this.methodCounter.getCoveredCount() > 0 ? CounterImpl.COUNTER_0_1 : CounterImpl.COUNTER_1_0;
        return true;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public boolean isNoMatch() {
        return this.noMatch;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public String getSuperName() {
        return this.superName;
    }

    @Override
    public String[] getInterfaceNames() {
        return this.interfaces;
    }

    @Override
    public String getPackageName() {
        int pos = this.getName().lastIndexOf(47);
        return pos == -1 ? "" : this.getName().substring(0, pos);
    }

    @Override
    public String getSourceFileName() {
        return this.sourceFileName;
    }

    @Override
    public Collection<IMethodCoverage> getMethods() {
        return this.methods;
    }
}

