/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.reflection;

import io.github.classgraph.ClassGraph;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.Callable;
import nonapi.io.github.classgraph.reflection.JVMDriverReflectionDriver;
import nonapi.io.github.classgraph.reflection.NarcissusReflectionDriver;
import nonapi.io.github.classgraph.reflection.ReflectionDriver;
import nonapi.io.github.classgraph.reflection.StandardReflectionDriver;

public final class ReflectionUtils {
    public static ReflectionDriver reflectionDriver;
    private static Class<?> accessControllerClass;
    private static Class<?> privilegedActionClass;
    private static Method accessControllerDoPrivileged;

    public static void loadReflectionDriver() {
        if (ClassGraph.CIRCUMVENT_ENCAPSULATION == ClassGraph.CircumventEncapsulationMethod.NARCISSUS) {
            try {
                reflectionDriver = new NarcissusReflectionDriver();
            }
            catch (Throwable t2) {
                System.err.println("Could not load Narcissus reflection driver: " + t2);
            }
        } else if (ClassGraph.CIRCUMVENT_ENCAPSULATION == ClassGraph.CircumventEncapsulationMethod.JVM_DRIVER) {
            try {
                reflectionDriver = new JVMDriverReflectionDriver();
            }
            catch (Throwable t3) {
                System.err.println("Could not load JVM-Driver reflection driver: " + t3);
            }
        }
        if (reflectionDriver == null) {
            reflectionDriver = new StandardReflectionDriver();
        }
    }

    private ReflectionUtils() {
    }

    public static Object getFieldVal(boolean throwException, Object obj, Field field) throws IllegalArgumentException {
        if (obj == null || field == null) {
            if (throwException) {
                throw new NullPointerException();
            }
            return null;
        }
        try {
            return reflectionDriver.getField(obj, field);
        }
        catch (Throwable e) {
            if (throwException) {
                throw new IllegalArgumentException("Can't read field " + obj.getClass().getName() + "." + field.getName() + ": " + e);
            }
            return null;
        }
    }

    public static Object getFieldVal(boolean throwException, Object obj, String fieldName) throws IllegalArgumentException {
        if (obj == null || fieldName == null) {
            if (throwException) {
                throw new NullPointerException();
            }
            return null;
        }
        try {
            return reflectionDriver.getField(obj, reflectionDriver.findInstanceField(obj, fieldName));
        }
        catch (Throwable e) {
            if (throwException) {
                throw new IllegalArgumentException("Can't read field " + obj.getClass().getName() + "." + fieldName + ": " + e);
            }
            return null;
        }
    }

    public static Object getStaticFieldVal(boolean throwException, Class<?> cls, String fieldName) throws IllegalArgumentException {
        if (cls == null || fieldName == null) {
            if (throwException) {
                throw new NullPointerException();
            }
            return null;
        }
        try {
            return reflectionDriver.getStaticField(reflectionDriver.findStaticField(cls, fieldName));
        }
        catch (Throwable e) {
            if (throwException) {
                throw new IllegalArgumentException("Can't read static field " + cls.getName() + "." + fieldName + ": " + e);
            }
            return null;
        }
    }

    public static Object invokeMethod(boolean throwException, Object obj, String methodName) throws IllegalArgumentException {
        if (obj == null || methodName == null) {
            if (throwException) {
                throw new IllegalArgumentException("Unexpected null argument");
            }
            return null;
        }
        try {
            return reflectionDriver.invokeMethod(obj, reflectionDriver.findInstanceMethod(obj, methodName, new Class[0]), new Object[0]);
        }
        catch (Throwable e) {
            if (throwException) {
                throw new IllegalArgumentException("Method \"" + methodName + "\" could not be invoked: " + e);
            }
            return null;
        }
    }

    public static Object invokeMethod(boolean throwException, Object obj, String methodName, Class<?> argType, Object param) throws IllegalArgumentException {
        if (obj == null || methodName == null || argType == null) {
            if (throwException) {
                throw new IllegalArgumentException("Unexpected null argument");
            }
            return null;
        }
        try {
            return reflectionDriver.invokeMethod(obj, reflectionDriver.findInstanceMethod(obj, methodName, argType), param);
        }
        catch (Throwable e) {
            if (throwException) {
                throw new IllegalArgumentException("Method \"" + methodName + "\" could not be invoked: " + e);
            }
            return null;
        }
    }

    public static Object invokeStaticMethod(boolean throwException, Class<?> cls, String methodName) throws IllegalArgumentException {
        if (cls == null || methodName == null) {
            if (throwException) {
                throw new IllegalArgumentException("Unexpected null argument");
            }
            return null;
        }
        try {
            return reflectionDriver.invokeStaticMethod(reflectionDriver.findStaticMethod(cls, methodName, new Class[0]), new Object[0]);
        }
        catch (Throwable e) {
            if (throwException) {
                throw new IllegalArgumentException("Static method \"" + methodName + "\" could not be invoked: " + e);
            }
            return null;
        }
    }

    public static Object invokeStaticMethod(boolean throwException, Class<?> cls, String methodName, Class<?> argType, Object param) throws IllegalArgumentException {
        if (cls == null || methodName == null || argType == null) {
            if (throwException) {
                throw new IllegalArgumentException("Unexpected null argument");
            }
            return null;
        }
        try {
            return reflectionDriver.invokeStaticMethod(reflectionDriver.findStaticMethod(cls, methodName, argType), param);
        }
        catch (Throwable e) {
            if (throwException) {
                throw new IllegalArgumentException("Static method \"" + methodName + "\" could not be invoked: " + e);
            }
            return null;
        }
    }

    public static Class<?> classForNameOrNull(String className) {
        try {
            return reflectionDriver.findClass(className);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Method staticMethodForNameOrNull(String className, String staticMethodName) {
        try {
            return reflectionDriver.findStaticMethod(reflectionDriver.findClass(className), staticMethodName, new Class[0]);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static <T> T doPrivileged(Callable<T> callable) throws Throwable {
        if (accessControllerDoPrivileged != null) {
            Object privilegedAction = Proxy.newProxyInstance(privilegedActionClass.getClassLoader(), new Class[]{privilegedActionClass}, new PrivilegedActionInvocationHandler<T>(callable));
            return (T)accessControllerDoPrivileged.invoke(null, privilegedAction);
        }
        return callable.call();
    }

    static {
        ReflectionUtils.loadReflectionDriver();
        try {
            accessControllerClass = Class.forName("java.security.AccessController");
            privilegedActionClass = Class.forName("java.security.PrivilegedAction");
            accessControllerDoPrivileged = accessControllerClass.getMethod("doPrivileged", privilegedActionClass);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class PrivilegedActionInvocationHandler<T>
    implements InvocationHandler {
        private final Callable<T> callable;

        public PrivilegedActionInvocationHandler(Callable<T> callable) {
            this.callable = callable;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.callable.call();
        }
    }
}

