/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classloaderhandler;

import java.io.File;
import java.util.List;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.reflection.ReflectionUtils;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.LogNode;

class TomcatWebappClassLoaderBaseHandler
implements ClassLoaderHandler {
    private TomcatWebappClassLoaderBaseHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        return "randoop.org.apache.catalina.loader.WebappClassLoaderBase".equals(classLoaderClass.getName());
    }

    private static boolean isParentFirst(ClassLoader classLoader) {
        Object delegateObject = ReflectionUtils.getFieldVal(false, (Object)classLoader, "delegate");
        if (delegateObject != null) {
            return (Boolean)delegateObject;
        }
        return true;
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder, LogNode log) {
        boolean isParentFirst = TomcatWebappClassLoaderBaseHandler.isParentFirst(classLoader);
        if (isParentFirst) {
            classLoaderOrder.delegateTo(classLoader.getParent(), true, log);
        }
        if ("randoop.org.apache.tomee.catalina.TomEEWebappClassLoader".equals(classLoader.getClass().getName())) {
            try {
                classLoaderOrder.delegateTo(Class.forName("randoop.org.apache.openejb.OpenEJB").getClassLoader(), true, log);
            }
            catch (ClassNotFoundException | LinkageError throwable) {
                // empty catch block
            }
        }
        classLoaderOrder.add(classLoader, log);
        if (!isParentFirst) {
            classLoaderOrder.delegateTo(classLoader.getParent(), true, log);
        }
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        Object resources = ReflectionUtils.invokeMethod(false, classLoader, "getResources");
        Object baseURLs = ReflectionUtils.invokeMethod(false, resources, "getBaseUrls");
        classpathOrder.addClasspathEntryObject(baseURLs, classLoader, scanSpec, log);
        List allResources = (List)ReflectionUtils.getFieldVal(false, resources, "allResources");
        if (allResources != null) {
            for (List webResourceSetList : allResources) {
                for (Object webResourceSet : webResourceSetList) {
                    String className;
                    String base;
                    if (webResourceSet == null) continue;
                    File file = (File)ReflectionUtils.invokeMethod(false, webResourceSet, "getFileBase");
                    String string = base = file == null ? null : file.getPath();
                    if (base == null) {
                        base = (String)ReflectionUtils.invokeMethod(false, webResourceSet, "getBase");
                    }
                    if (base == null) {
                        base = (String)ReflectionUtils.invokeMethod(false, webResourceSet, "getBaseUrlString");
                    }
                    if (base == null) continue;
                    String archivePath = (String)ReflectionUtils.getFieldVal(false, webResourceSet, "archivePath");
                    if (archivePath != null && !archivePath.isEmpty()) {
                        base = base + "!" + (archivePath.startsWith("/") ? archivePath : "/" + archivePath);
                    }
                    boolean isJar = (className = webResourceSet.getClass().getName()).equals("java.org.apache.catalina.webresources.JarResourceSet") || className.equals("java.org.apache.catalina.webresources.JarWarResourceSet");
                    String internalPath = (String)ReflectionUtils.invokeMethod(false, webResourceSet, "getInternalPath");
                    if (internalPath != null && !internalPath.isEmpty() && !internalPath.equals("/")) {
                        classpathOrder.addClasspathEntryObject(base + (isJar ? "!" : "") + (internalPath.startsWith("/") ? internalPath : "/" + internalPath), classLoader, scanSpec, log);
                        continue;
                    }
                    classpathOrder.addClasspathEntryObject(base, classLoader, scanSpec, log);
                }
            }
        }
        Object urls = ReflectionUtils.invokeMethod(false, classLoader, "getURLs");
        classpathOrder.addClasspathEntryObject(urls, classLoader, scanSpec, log);
    }
}

