/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.github.javaparser.utils;

import coveredclass.org.github.javaparser.ast.type.PrimitiveType;
import coveredclass.org.github.javaparser.ast.type.VoidType;
import java.lang.reflect.Method;
import java.util.Optional;

public class TypeUtils {
    public static String getMethodDescriptor(Method method) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (Class<?> parameter : method.getParameterTypes()) {
            TypeUtils.appendDescriptor(parameter, stringBuilder);
        }
        stringBuilder.append(")");
        TypeUtils.appendDescriptor(method.getReturnType(), stringBuilder);
        return stringBuilder.toString();
    }

    private static void appendDescriptor(Class<?> clazz, StringBuilder stringBuilder) {
        Class<?> currentClass = clazz;
        while (currentClass.isArray()) {
            stringBuilder.append("[");
            currentClass = currentClass.getComponentType();
        }
        if (currentClass.isPrimitive()) {
            String descriptor = TypeUtils.getPrimitiveTypeDescriptor(currentClass);
            stringBuilder.append(descriptor);
        } else {
            stringBuilder.append("L").append(currentClass.getName().replace(".", "/")).append(";");
        }
    }

    public static String getPrimitiveTypeDescriptor(Class<?> clazz) {
        if (clazz == Void.TYPE || clazz == Void.class) {
            return new VoidType().toDescriptor();
        }
        String className = clazz.getSimpleName();
        Optional<PrimitiveType.Primitive> prim = PrimitiveType.Primitive.byTypeName(className);
        if (prim.isPresent()) {
            return prim.get().toDescriptor();
        }
        prim = PrimitiveType.Primitive.byBoxedTypeName(className);
        return prim.map(pType -> pType.toDescriptor()).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown primitive type \"%s\"", className)));
    }
}

