/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.github.javaparser.resolution.model;

import coveredclass.org.github.javaparser.resolution.UnsolvedSymbolException;
import coveredclass.org.github.javaparser.resolution.declarations.ResolvedDeclaration;
import java.util.Optional;

public class SymbolReference<S extends ResolvedDeclaration> {
    private final S correspondingDeclaration;

    public static <S extends ResolvedDeclaration, S2 extends S> SymbolReference<S> solved(S2 symbolDeclaration) {
        return new SymbolReference<S2>(symbolDeclaration);
    }

    public static <S extends ResolvedDeclaration> SymbolReference<S> unsolved() {
        return new SymbolReference<Object>(null);
    }

    @Deprecated
    public static <S extends ResolvedDeclaration, S2 extends S> SymbolReference<S> unsolved(Class<S2> clazz) {
        return SymbolReference.unsolved();
    }

    public static <I extends ResolvedDeclaration, O extends ResolvedDeclaration> SymbolReference<O> adapt(SymbolReference<I> ref, Class<O> clazz) {
        ResolvedDeclaration symbol;
        Optional<I> declaration = ref.getDeclaration();
        if (declaration.isPresent() && clazz.isInstance(symbol = (ResolvedDeclaration)declaration.get())) {
            return SymbolReference.solved((ResolvedDeclaration)clazz.cast(symbol));
        }
        return SymbolReference.unsolved();
    }

    private SymbolReference(S correspondingDeclaration) {
        this.correspondingDeclaration = correspondingDeclaration;
    }

    public Optional<S> getDeclaration() {
        return Optional.ofNullable(this.correspondingDeclaration);
    }

    public S getCorrespondingDeclaration() {
        return (S)((ResolvedDeclaration)this.getDeclaration().orElseThrow(() -> new UnsolvedSymbolException("Corresponding declaration not available for unsolved symbol.")));
    }

    public boolean isSolved() {
        return this.getDeclaration().isPresent();
    }

    public String toString() {
        return "SymbolReference{" + this.correspondingDeclaration + "}";
    }
}

